<?php
include "php/proteger_admin.php";
include "php/conexion.php";

$sql = $cn->query("SELECT * FROM usuarios ORDER BY nombre ASC");
?>

<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Mantenimiento de Usuarios</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

<style>
body{
    background:#f4f6f9;
    padding:20px;
}

/* PANEL */
.panel{
    border-radius:10px;
}

/* ===== RESPONSIVE ===== */
@media(max-width:768px){
    .tabla-pc{
        display:none;
    }
}
@media(min-width:769px){
    .tarjetas-movil{
        display:none;
    }
}

/* TARJETAS */
.usuario-card{
    background:#fff;
    border-radius:10px;
    padding:15px;
    margin-bottom:15px;
    border:1px solid #ddd;
}
.usuario-card h4{
    margin-top:0;
    font-weight:bold;
}
.usuario-card .btn{
    margin-top:5px;
}
</style>
</head>

<body>
<div class="container">

<h2 class="text-center"><b>Mantenimiento de Usuarios</b></h2>
<hr>

<div class="text-center">
    <a href="usuario_form.php" class="btn btn-success">
        <span class="glyphicon glyphicon-plus"></span> Nuevo Usuario
    </a>
    <a href="admin.php" class="btn btn-default">
        <span class="glyphicon glyphicon-arrow-left"></span> Volver
    </a>
</div>

<br>

<!-- =================== -->
<!-- TABLA PC -->
<!-- =================== -->
<div class="panel panel-default tabla-pc">
<div class="panel-body">

<table class="table table-bordered table-hover">
<thead>
<tr class="info">
    <th>Nombre</th>
    <th>Usuario</th>
    <th>Rol</th>
    <th>Estado</th>
    <th width="160">Acciones</th>
</tr>
</thead>

<tbody>
<?php mysqli_data_seek($sql,0); while($u = $sql->fetch_assoc()){ ?>
<tr>
    <td><?= $u['nombre'] ?></td>
    <td><?= $u['usuario'] ?></td>
    <td><span class="label label-primary"><?= $u['rol'] ?></span></td>
    <td class="text-center">
        <?= $u['estado']
            ? "<span class='label label-success'>Activo</span>"
            : "<span class='label label-danger'>Inactivo</span>" ?>
    </td>
    <td class="text-center">
        <a href="usuario_form.php?id=<?= $u['id'] ?>" class="btn btn-primary btn-xs">
            ✏ Editar
        </a>
        <a href="php/activar_usuario.php?id=<?= $u['id'] ?>" class="btn btn-warning btn-xs">
            <?= $u['estado']?'Desactivar':'Activar' ?>
        </a>
    </td>
</tr>
<?php } ?>
</tbody>
</table>

</div>
</div>

<!-- =================== -->
<!-- TARJETAS MOVIL -->
<!-- =================== -->
<div class="tarjetas-movil">
<?php mysqli_data_seek($sql,0); while($u = $sql->fetch_assoc()){ ?>
    <div class="usuario-card">

        <h4><?= $u['nombre'] ?></h4>

        <p><b>Usuario:</b> <?= $u['usuario'] ?></p>
        <p><b>Rol:</b> <span class="label label-primary"><?= $u['rol'] ?></span></p>
        <p>
            <b>Estado:</b>
            <?= $u['estado']
                ? "<span class='label label-success'>Activo</span>"
                : "<span class='label label-danger'>Inactivo</span>" ?>
        </p>

        <a href="usuario_form.php?id=<?= $u['id'] ?>" class="btn btn-primary btn-block">
            ✏ Editar
        </a>

        <a href="php/activar_usuario.php?id=<?= $u['id'] ?>" class="btn btn-warning btn-block">
            <?= $u['estado']?'Desactivar':'Activar' ?>
        </a>

    </div>
<?php } ?>
</div>

</div>
</body>
</html>
