<?php include "php/conexion.php"; ?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Reportes de Ventas</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

    <script src="https://www.gstatic.com/charts/loader.js"></script>

    <style>
        body { background:#f4f6f9; padding:20px; }
        .panel-custom { border-radius:8px; box-shadow:0 2px 6px #ccc; }
        #charts .panel { padding:15px; }
    </style>
</head>
<body>

<div class="container">
    <h2 class="text-center"><b>📊 Reportes de Ventas</b><a href="admin.php" class="btn btn-default">Volver</a></h2>
    <hr>

    <!-- FILTRO -->
    <form method="GET" class="row">
        <div class="col-sm-4">
            <label>Fecha inicio:</label>
            <input type="date" name="desde" class="form-control"
                   value="<?= isset($_GET['desde'])?$_GET['desde']:date('Y-m-d') ?>">
        </div>

        <div class="col-sm-4">
            <label>Fecha fin:</label>
            <input type="date" name="hasta" class="form-control"
                   value="<?= isset($_GET['hasta'])?$_GET['hasta']:date('Y-m-d') ?>">
        </div>

        <div class="col-sm-4">
            <br>
            <button class="btn btn-primary btn-block"><span class="glyphicon glyphicon-search"></span> Filtrar</button>
        </div>
    </form>

    <hr>

    <div id="charts" class="row">

        <div class="col-md-6">
            <div class="panel panel-custom">
                <h4 class="text-center">Ventas por Producto</h4>
                <div id="chart_productos" style="height:350px;"></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-custom">
                <h4 class="text-center">Ventas por Día</h4>
                <div id="chart_dias" style="height:350px;"></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-custom">
                <h4 class="text-center">Delivery vs Tienda</h4>
                <div id="chart_delivery" style="height:350px;"></div>
            </div>
        </div>

        <div class="col-md-6">
            <div class="panel panel-custom">
                <h4 class="text-center">Estado de Pedidos</h4>
                <div id="chart_estados" style="height:350px;"></div>
            </div>
        </div>

    </div>

</div>

<?php include "php/reportes_data.php"; ?>

</body>
</html>
