<?php
include "php/conexion.php";

// Compatibilidad PHP 5.6 (No existe ??)
$desde = isset($_GET["desde"]) ? $_GET["desde"] : date("Y-m-01");
$hasta = isset($_GET["hasta"]) ? $_GET["hasta"] : date("Y-m-d");

// Total general
$sqlTotal = "
SELECT SUM(total) AS total, SUM(costo_delivery) as delivery
FROM pedidos
WHERE estado<>'ANULADO' AND DATE(fecha) BETWEEN '$desde' AND '$hasta'
";

$resTotal = $cn->query($sqlTotal);
$rowTotal = $resTotal->fetch_assoc();
$total = $rowTotal["total"];
$delivery = $rowTotal["delivery"];
if (!$total) { $total = 0; }
if (!$delivery) { $delivery = 0; }
// Totales por producto
$sqlProd = "
SELECT pr.nombre, SUM(d.cantidad) AS cant, SUM(d.subtotal) AS total
FROM pedido_detalle d
INNER JOIN productos pr ON pr.id = d.idproducto
INNER JOIN pedidos p ON p.id = d.idpedido
WHERE DATE(p.fecha) BETWEEN '$desde' AND '$hasta'
GROUP BY pr.id
ORDER BY total DESC
";
$productos = $cn->query($sqlProd);

// Detalle de ventas
$sqlDetalle = "
SELECT p.id, p.fecha, p.cliente, p.total,p.estado,p.costo_delivery
FROM pedidos p
WHERE DATE(p.fecha) BETWEEN '$desde' AND '$hasta'
ORDER BY p.fecha DESC
";
$detalle = $cn->query($sqlDetalle);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Reporte de Ventas</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>

<body class="container mt-4">

<h2>Reporte de Ventas</h2>

<form method="GET" class="row g-3 mb-4">

    <div class="col-md-4">
        <label>Desde</label>
        <input type="date" name="desde" class="form-control" value="<?php echo $desde; ?>">
    </div>

    <div class="col-md-4">
        <label>Hasta</label>
        <input type="date" name="hasta" class="form-control" value="<?php echo $hasta; ?>">
    </div>

    <div class="col-md-4 d-flex align-items-end">
        <button class="btn btn-primary">Filtrar</button>
    </div>

</form>

<!-- Total general -->
<div class="alert alert-success">
    <h4>Total vendido: S/ <?php echo number_format($total, 2); ?> | Total Delivery: S/. <?php echo number_format($delivery, 2); ?></h4>
</div>

<hr>

<h4>Venta por producto</h4>

<table class="table table-bordered table-striped">
    <thead class="table-dark">
        <tr>
            <th>Producto</th>
            <th>Cantidad</th>
            <th>Total (S/)</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $productos->fetch_assoc()) { ?>
        <tr>
            <td><?php echo $row["nombre"]; ?></td>
            <td><?php echo $row["cant"]; ?></td>
            <td><?php echo number_format($row["total"], 2); ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<hr>

<h4>Detalle de pedidos</h4>

<table class="table table-bordered">
    <thead class="table-dark">
        <tr>
            
            <th>Fecha</th>
            <th>Cliente</th>
            <th>Total (S/)</th>
            <th>Delivery (S/)</th>
            <th>Estado</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $detalle->fetch_assoc()) { ?>
        <tr>
            
            <td><?php echo $row["fecha"]; ?></td>
            <td><?php echo $row["cliente"]; ?></td>
            <td><?php echo number_format($row["total"], 2); ?></td>
            <td><?php echo number_format($row["costo_delivery"], 2); ?></td>
            <td><?php echo $row["estado"]; ?></td>
        </tr>
        <?php } ?>
    </tbody>
</table>

<a href="admin.php" class="btn btn-secondary mt-3">Volver al Panel</a>

</body>
</html>
