<?php

$desde = isset($_GET['desde']) ? $_GET['desde'] : date('Y-m-d');
$hasta = isset($_GET['hasta']) ? $_GET['hasta'] : date('Y-m-d');

$where = "WHERE DATE(fecha) BETWEEN '$desde' AND '$hasta'";

// ==========================================
// 1. VENTAS POR PRODUCTO
// ==========================================
$q1 = $cn->query("
    SELECT p.nombre, SUM(d.cantidad) as total
    FROM pedido_detalle d
    INNER JOIN productos p ON p.id = d.idproducto
    INNER JOIN pedidos pe ON pe.id = d.idpedido
    $where AND pe.estado='ENTREGADO'
    GROUP BY d.idproducto
");

$data_productos = [];
while($r = $q1->fetch_assoc()){
    $data_productos[] = "['".$r['nombre']."', ".$r['total']."]";
}

// ==========================================
// 2. VENTAS POR DÍA (INGRESO)
// ==========================================
$q2 = $cn->query("
    SELECT DATE(fecha) as dia, SUM(total) as total
    FROM pedidos
    $where AND estado='ENTREGADO'
    GROUP BY dia
");

$data_dias = [];
while($r = $q2->fetch_assoc()){
    $data_dias[] = "['".$r['dia']."', ".$r['total']."]";
}

// ==========================================
// 3. DELIVERY VS TIENDA
// ==========================================
$q3 = $cn->query("
    SELECT 
        SUM(CASE WHEN costo_delivery > 0 THEN total ELSE 0 END) AS delivery,
        SUM(CASE WHEN costo_delivery = 0 THEN total ELSE 0 END) AS tienda
    FROM pedidos
    $where AND estado='ENTREGADO'
");

$row = $q3->fetch_assoc();
$data_delivery = "
    ['Delivery', ".$row['delivery']."],
    ['Tienda', ".$row['tienda']."]
";

// ==========================================
// 4. ESTADOS DE PEDIDOS
// ==========================================
$q4 = $cn->query("
    SELECT estado, COUNT(*) as total
    FROM pedidos
    $where
    GROUP BY estado
");

$data_estados = [];
while($r = $q4->fetch_assoc()){
    $data_estados[] = "['".$r['estado']."', ".$r['total']."]";
}

?>

<script>
google.charts.load('current', {'packages':['corechart']});
google.charts.setOnLoadCallback(drawCharts);

function drawCharts(){

    // ===========================
    // VENTAS POR PRODUCTO
    // ===========================
    var data1 = google.visualization.arrayToDataTable([
        ['Producto','Cantidad'],
        <?= implode(",", $data_productos) ?>
    ]);

    new google.visualization.PieChart(document.getElementById('chart_productos'))
        .draw(data1, {pieHole:0.3});

    // ===========================
    // VENTAS POR DÍA
    // ===========================
    var data2 = google.visualization.arrayToDataTable([
        ['Fecha','Total'],
        <?= implode(",", $data_dias) ?>
    ]);

    new google.visualization.ColumnChart(document.getElementById('chart_dias'))
        .draw(data2);

    // ===========================
    // DELIVERY VS TIENDA
    // ===========================
    var data3 = google.visualization.arrayToDataTable([
        ['Tipo', 'Total'],
        <?= $data_delivery ?>
    ]);
    
    new google.visualization.PieChart(document.getElementById('chart_delivery'))
        .draw(data3, {pieHole:0.4});

    // ===========================
    // ESTADOS DE PEDIDOS
    // ===========================
    var data4 = google.visualization.arrayToDataTable([
        ['Estado','Cantidad'],
        <?= implode(",", $data_estados) ?>
    ]);

    new google.visualization.PieChart(document.getElementById('chart_estados'))
        .draw(data4);
}
</script>
