<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

include "php/proteger_mozo.php";
include "php/conexion.php";

/* ============================
   PEDIDOS DEL DÍA
============================ */
$sqlPedidos = $cn->query("
    SELECT COUNT(*) AS total 
    FROM pedidos 
    WHERE DATE(fecha) = CURDATE()
    AND estado <> 'ANULADO'
");
$totalPedidos = $sqlPedidos->fetch_assoc()['total'];

/* ============================
   PEDIDOS PENDIENTES
============================ */
$sqlPend = $cn->query("
    SELECT COUNT(*) AS c 
    FROM pedidos 
    WHERE estado = 'PENDIENTE'
");
$pendientes = $sqlPend->fetch_assoc()['c'];

/* ============================
   PEDIDOS LISTOS
============================ */
$sqlListo = $cn->query("
    SELECT COUNT(*) AS c 
    FROM pedidos 
    WHERE estado = 'LISTO'
");
$listos = $sqlListo->fetch_assoc()['c'];
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Panel Mozo</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 5 -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

    <!-- Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body { background:#f4f7fb; }

        .card-dashboard {
            border-radius: 15px;
            padding: 20px;
            color: white;
            box-shadow: 0 4px 12px rgba(0,0,0,.1);
            transition: transform .2s;
        }
        .card-dashboard:hover {
            transform: translateY(-5px);
        }

        .btn-menu {
            border-radius: 12px;
            padding: 18px;
            font-size: 17px;
            font-weight: 600;
            text-align: left;
            display: block;
            box-shadow: 0 3px 10px rgba(0,0,0,.1);
            transition: transform .2s;
        }
        .btn-menu:hover {
            transform: translateX(5px);
        }
    </style>
</head>

<body class="container mt-4">

<div class="d-flex justify-content-between align-items-center mb-4">

    <h2 class="fw-bold m-0">
        <i class="bi bi-person-badge"></i> Panel del Mozo
    </h2>

    <a href="logout.php" class="btn btn-outline-danger">
        <i class="bi bi-box-arrow-right"></i> Cerrar sesión
    </a>

</div>


<div class="row g-4">

    <div class="col-md-4">
        <div class="card-dashboard" style="background:#0d6efd;">
            <h5><i class="bi bi-receipt"></i> Pedidos del día</h5>
            <h2><?= $totalPedidos ?></h2>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card-dashboard" style="background:#ffc107;">
            <h5><i class="bi bi-hourglass-split"></i> Pendientes</h5>
            <h2><?= $pendientes ?></h2>
        </div>
    </div>

    <div class="col-md-4">
        <div class="card-dashboard" style="background:#198754;">
            <h5><i class="bi bi-check-circle"></i> Listos</h5>
            <h2><?= $listos ?></h2>
        </div>
    </div>

</div>

<hr class="my-4">

<h4 class="fw-bold mb-3">
    <i class="bi bi-grid"></i> Accesos rápidos
</h4>

<div class="row g-3">

    <div class="col-md-6">
        <a href="index.php" class="btn btn-primary btn-menu">
            <i class="bi bi-plus-circle"></i> Registrar Pedido
        </a>
    </div>

    <div class="col-md-6">
        <a href="manpedidos.php" class="btn btn-warning btn-menu">
            <i class="bi bi-pencil-square"></i> Editar Pedidos
        </a>
    </div>

    <div class="col-md-6">
        <a href="despacho.php" class="btn btn-success btn-menu">
            <i class="bi bi-truck"></i> Entregar Pedidos
        </a>
    </div>

    <div class="col-md-6">
        <a href="cocina.php" class="btn btn-danger btn-menu">
            <i class="bi bi-egg-fried"></i> Ver Cocina
        </a>
    </div>

</div>

</body>
</html>
