<?php
include "php/conexion.php";

// --- Filtros ---
$cliente = isset($_GET['cliente']) ? trim($_GET['cliente']) : "";
$fecha_ini = isset($_GET['fecha_ini']) ? $_GET['fecha_ini'] : "";
$fecha_fin = isset($_GET['fecha_fin']) ? $_GET['fecha_fin'] : "";

$where = " WHERE 1=1 ";  // Base flexible

// --- Si NO hay filtros, mostrar solo pedidos del da ---
if ($cliente == "" && $fecha_ini == "" && $fecha_fin == "") {
    $where .= " AND DATE(fecha) = CURDATE() ";
}

// --- Si hay filtros, aplicar filtros libres ---
if ($cliente != "") {
    $cliente = $cn->real_escape_string($cliente);
    $where .= " AND cliente LIKE '%$cliente%' ";
}

if ($fecha_ini != "") {
    $where .= " AND DATE(fecha) >= '$fecha_ini' ";
}

if ($fecha_fin != "") {
    $where .= " AND DATE(fecha) <= '$fecha_fin' ";
}

$sql = $cn->query("SELECT * FROM pedidos $where ORDER BY fecha DESC");
?>


<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Mantenimiento de Pedidos</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 3 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

    <style>
        body {
            background: #f4f6f9;
            padding: 30px;
        }

        .panel-custom {
            border-radius: 10px;
            border: 1px solid #ddd;
        }

        table th {
            background: #007bff;
            color: white;
            text-align: center;
        }

        .search-box {
            padding: 20px;
            border-radius: 10px;
            background: white;
            margin-bottom: 20px;
            border: 1px solid #ddd;
        }

        /* --- RESPONSIVE MAGIC --- */
        @media(max-width: 768px){
            .table-wrapper {
                display: none; /* Ocultar tabla en celular */
            }
            .accordion-wrapper {
                display: block;
            }
        }
        @media(min-width: 769px){
            .accordion-wrapper {
                display: none; /* Ocultar acordeón en PC */
            }
        }

        /* Estilos para tarjetas */
        .pedido-card {
            background: white;
            border-radius: 10px;
            margin-bottom: 10px;
            padding: 15px;
            border: 1px solid #ccc;
        }
        .pedido-header {
            font-size: 16px;
            font-weight: bold;
        }
        .pedido-body {
            padding-left: 15px;
        }
    </style>
</head>
<body>

<div class="container">

    <h2 class="text-center"><b>Mantenimiento de Pedidos</b></h2>
    <hr>

    <!-- BUSCADOR -->
    <div class="search-box">
        <form class="form-inline" method="GET" action="">

            <div class="form-group">
                <label>Cliente:</label>
                <input type="text" name="cliente" class="form-control" value="<?= $cliente ?>">
            </div>

            <div class="form-group">
                <label>Desde:</label>
                <input type="date" name="fecha_ini" class="form-control" value="<?= $fecha_ini ?>">
            </div>

            <div class="form-group">
                <label>Hasta:</label>
                <input type="date" name="fecha_fin" class="form-control" value="<?= $fecha_fin ?>">
            </div>

            <button class="btn btn-primary" type="submit">
                <span class="glyphicon glyphicon-search"></span> Buscar
            </button>

            <a href="manpedidos.php" class="btn btn-default">
                <span class="glyphicon glyphicon-refresh"></span> Limpiar
            </a>

            <a href="php/volver_panel.php" class="btn btn-default">Volver</a>
        </form>
    </div>

    <!-- TABLA EN PC -->
    <div class="panel panel-custom table-wrapper">
        <div class="panel-body">

            <table class="table table-bordered table-hover table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Cliente</th>
                        <th>Fecha</th>
                        <th>Importe</th>
                        <th>Modo de Pago</th>
                        <th>Delivery</th>
                        <th>Total</th>
                        <th>Estado</th>
                        <th>Acciones</th>
                    </tr>
                </thead>

                <tbody>
                <?php while($p = $sql->fetch_assoc()){ ?>
                    <tr>
                        <td class="text-center"><?= $p['coddia'] ?></td>
                        <td><?= $p['cliente'] ?></td>
                        <td><?= date("d/m/Y", strtotime($p['fecha'])) . " " . $p['hora_entrega'] ?></td>
                        <td class="text-right">S/. <?= number_format($p['total'],2) ?></td>
                        <td class="text-right"><?= $p['modo_pago'] ?></td>
                        <td class="text-right">S/. <?= number_format($p['costo_delivery'],2) ?></td>
                        <td class="text-right">S/. <?= number_format($p['costo_delivery']+$p['total'],2) ?></td>

                        <td class="text-center">
                            <?php
                                if ($p['estado'] == "ENTREGADO") echo '<span class="label label-success">Entregado</span>';
                                elseif ($p['estado'] == "ANULADO") echo '<span class="label label-danger">Anulado</span>';
                                else echo '<span class="label label-warning">Pendiente</span>';
                            ?>
                        </td>

                        <td class="text-center">
                            <a href="editar_pedido.php?id=<?= $p['id'] ?>" class="btn btn-primary btn-xs">
                                <span class="glyphicon glyphicon-pencil"></span> Editar
                            </a>
                        </td>
                    </tr>
                <?php } ?>
                </tbody>

            </table>

        </div>
    </div>

    <!-- MODO ACORDEÓN EN CELULAR -->
    <div class="accordion-wrapper">
        <?php mysqli_data_seek($sql, 0); // Reset pointer ?>

        <?php while($p = $sql->fetch_assoc()){ ?>
        <div class="pedido-card">

            <div class="pedido-header" data-toggle="collapse" data-target="#p<?= $p['id'] ?>">
                Pedido #<?= $p['coddia'] ?> - <b><?= $p['cliente'] ?></b>
                <span class="pull-right glyphicon glyphicon-menu-down"></span>
            </div>

            <div id="p<?= $p['id'] ?>" class="collapse pedido-body">

                <p><b>Fecha:</b> <?= date("d/m/Y", strtotime($p['fecha'])) ?> <?= $p['hora_entrega'] ?></p>
                <p><b>Importe:</b> S/. <?= number_format($p['total'],2) ?></p>
                <p><b>Pago:</b> <?= $p['modo_pago'] ?></p>
                <p><b>Delivery:</b> S/. <?= number_format($p['costo_delivery'],2) ?></p>
                <p><b>Total:</b> S/. <?= number_format($p['costo_delivery']+$p['total'],2) ?></p>

                <p>
                    <b>Estado:</b>
                    <?php
                        if($p['estado']=="ENTREGADO") echo "<span class='label label-success'>Entregado</span>";
                        elseif($p['estado']=="ANULADO") echo "<span class='label label-danger'>Anulado</span>";
                        else echo "<span class='label label-warning'>Pendiente</span>";
                    ?>
                </p>

                <a href="editar_pedido.php?id=<?= $p['id'] ?>" class="btn btn-primary btn-block">
                    <span class="glyphicon glyphicon-pencil"></span> Editar
                </a>

            </div>
        </div>
        <?php } ?>
    </div>

</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

</body>
</html>
