<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Login | Sistema de Pedidos</title>
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap 5 -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

<style>
body{
    min-height:100vh;
    background: linear-gradient(135deg,#0d6efd,#00c6ff);
    display:flex;
    align-items:center;
    justify-content:center;
}

.login-card{
    background:#fff;
    border-radius:18px;
    padding:35px;
    width:100%;
    max-width:380px;
    box-shadow:0 15px 40px rgba(0,0,0,.25);
    animation: fadeIn .6s ease-in-out;
}

@keyframes fadeIn {
    from { opacity:0; transform:translateY(20px); }
    to { opacity:1; transform:translateY(0); }
}

.logo{
    width:80px;
    height:80px;
    border-radius:50%;
    background:#0d6efd;
    display:flex;
    align-items:center;
    justify-content:center;
    margin:0 auto 15px;
    color:#fff;
    font-size:38px;
}

.btn-login{
    border-radius:30px;
    font-weight:600;
}

.form-control{
    border-radius:10px;
    padding:12px;
}
</style>
</head>

<body>

<div class="login-card">

    <!-- LOGO -->
    <div class="logo">
        <i class="bi bi-receipt-cutoff"></i>
    </div>

    <h4 class="text-center fw-bold mb-3">Sistema de Pedidos</h4>
    <p class="text-center text-muted mb-4">
        Ingrese sus credenciales
    </p>

    <!-- MENSAJE ERROR -->
    <?php if(isset($_GET['error'])){ ?>
        <div class="alert alert-danger text-center py-2">
            <i class="bi bi-exclamation-triangle"></i>
            Usuario o contrasea incorrectos
        </div>
    <?php } ?>

    <!-- FORMULARIO -->
    <form method="POST" action="php/login_procesar.php">

        <div class="mb-3">
            <label class="form-label">Usuario</label>
            <div class="input-group">
                <span class="input-group-text">
                    <i class="bi bi-person"></i>
                </span>
                <input type="text" name="usuario" class="form-control" required>
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label">Password</label>
            <div class="input-group">
                <span class="input-group-text">
                    <i class="bi bi-lock"></i>
                </span>
                <input type="password" name="clave" class="form-control" required>
            </div>
        </div>

        <button type="submit" class="btn btn-primary btn-login w-100 py-2">
            <i class="bi bi-box-arrow-in-right"></i> Ingresar
        </button>

    </form>

    <hr class="my-4">

    <p class="text-center text-muted mb-0" style="font-size:13px;">
       <?= date('Y') ?> Sistema de Pedidos
    </p>

</div>

</body>
</html>
