<?php include "php/conexion.php"; ?>
<!DOCTYPE html>
<html>
<head>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>
<body class="container mt-4">

<h3 class="mb-3">Productos</h3>
<a href="registrar_producto.php" class="btn btn-primary mb-3">+ Nuevo Producto</a>
<a href="admin.php" class="btn btn-warning mb-3">Regresar</a>

<table class="table table-bordered table-striped">
    <thead class="table-dark">
        <tr>
            <th>Foto</th>
            <th>Nombre</th>
            <th>Precio</th>
            <th>Categoría</th>
            <th>Opciones</th>
        </tr>
    </thead>

    <tbody>
        <?php
        $r = $cn->query("SELECT * FROM productos");
        while ($row = $r->fetch_assoc()) {
        ?>
        <tr>
            <td>
                <?php if ($row["foto"]): ?>
                    <img src="uploads/<?= $row['foto'] ?>" width="70">
                <?php else: ?>
                    <span class="text-muted">Sin foto</span>
                <?php endif; ?>
            </td>

            <td><?= $row["nombre"] ?></td>
            <td>S/ <?= number_format($row["precio"], 2) ?></td>
            <td><?= $row["categoria"] ?></td>

            <td>
                <a href="editar_producto.php?id=<?= $row['id'] ?>" class="btn btn-warning btn-sm">Editar</a>
                <a href="eliminar_producto.php?id=<?= $row['id'] ?>" 
                   class="btn btn-danger btn-sm"
                   onclick="return confirm('¿Eliminar producto?')">Eliminar</a>
            </td>
        </tr>
        <?php } ?>
    </tbody>
</table>

</body>
</html>
