<?php
include "php/conexion.php";

$id = $_GET['id'];

// =====================
// OBTENER DATOS GENERALES
// =====================
$pedido = $cn->query("SELECT * FROM pedidos WHERE id=$id")->fetch_assoc();

// =====================
// OBTENER DETALLE DEL PEDIDO
// =====================
$det = $cn->query("
    SELECT d.id AS iddet, d.idproducto, p.nombre, d.cantidad, d.precio_unitario, d.subtotal
    FROM pedido_detalle d
    INNER JOIN productos p ON p.id = d.idproducto
    WHERE d.idpedido = $id
");

// =====================
// OBTENER PRODUCTOS PARA LISTA (BUSCADOR)
// =====================
$productos = $cn->query("SELECT * FROM productos ORDER BY nombre ASC");

?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Editar Pedido</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap 3 -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

<style>
body {
    background: #f4f6f9;
    padding: 20px;
}

.panel-custom {
    border-radius: 10px;
    border: 1px solid #ddd;
    box-shadow: 0px 2px 6px #ccc;
}

.table > tbody > tr > td {
    vertical-align: middle;
}

@media(max-width:768px){
    .table-responsive {
        border: none;
    }
}
</style>
</head>
<body>

<div class="container">
    
    <a href="manpedidos.php" class="btn btn-default">
        <span class="glyphicon glyphicon-arrow-left"></span> Volver
    </a>

    <h2 class="text-center"><b>Editar Pedido #<?= $pedido['coddia'] ?></b></h2>
    <hr>

<form method="POST" action="php/guardar_edicion_pedido.php">

<input type="hidden" name="idpedido" value="<?= $id ?>">

<!-- ===================== -->
<!-- PANEL DATOS GENERALES -->
<!-- ===================== -->
<div class="panel panel-custom">
    <div class="panel-heading"><b>Datos del Pedido</b></div>
    <div class="panel-body">

        <div class="row">

            <div class="col-sm-6">
                <label>Cliente:</label>
                <input type="text" class="form-control" name="cliente" required
                       value="<?= $pedido['cliente'] ?>">
            </div>

            <div class="col-sm-3">
                <label>Telefono:</label>
                <input type="text" class="form-control" name="telefono" 
                       value="<?= $pedido['telefono'] ?>">
            </div>

            <div class="col-sm-3">
                <label>Modo de pago:</label>
                <select name="modo_pago" class="form-control">
                    <option <?= $pedido['modo_pago']=='EFECTIVO'?'selected':'' ?>>EFECTIVO</option>
                    <option <?= $pedido['modo_pago']=='YAPE'?'selected':'' ?>>YAPE</option>
                    <option <?= $pedido['modo_pago']=='PLIN'?'selected':'' ?>>PLIN</option>
                    <option <?= $pedido['modo_pago']=='TARJETA'?'selected':'' ?>>TARJETA</option>
                </select>
            </div>

        </div>

        <br>

        <div class="row">
            <div class="col-sm-4">
                <label>Hora entrega:</label>
                <input type="time" class="form-control" name="hora_entrega"
                       value="<?= $pedido['hora_entrega'] ?>">
            </div>

            <div class="col-sm-4">
                <label>Costo delivery:</label>
                <input type="number" class="form-control" name="costo_delivery"
                       step="0.10" value="<?= $pedido['costo_delivery'] ?>">
            </div>

            <div class="col-sm-4">
                <label>Estado:</label>
                <select class="form-control" name="estado">
                    <option <?= $pedido['estado']=='PENDIENTE'?'selected':'' ?>>PENDIENTE</option>
                    <option <?= $pedido['estado']=='ENTREGADO'?'selected':'' ?>>ENTREGADO</option>
                    <option <?= $pedido['estado']=='ANULADO'?'selected':'' ?>>ANULADO</option>
                </select>
            </div>
        </div>

    </div>
</div>

<!-- ===================== -->
<!-- DETALLE DEL PEDIDO -->
<!-- ===================== -->

<div class="panel panel-custom">
    <div class="panel-heading"><b>Productos del Pedido</b></div>
    <div class="panel-body">

        <div class="table-responsive">
        <table class="table table-bordered table-hover">
            <thead>
                <tr>
                    <th>Producto</th>
                    <th width="90px">Cant.</th>
                    <th width="110px">Precio</th>
                    <th width="110px">Subtotal</th>
                    <th width="120px">Accion</th>
                </tr>
            </thead>

            <tbody id="detalle-tabla">

            <?php while($d = $det->fetch_assoc()){ ?>
                <tr>
                    <td><?= $d['nombre'] ?></td>

                    <td>
                        <input type="number" name="cantidad[<?= $d['iddet'] ?>]"
                               class="form-control input-sm cant"
                               min="1" value="<?= $d['cantidad'] ?>">
                    </td>

                    <td>S/. <?= number_format($d['precio_unitario'],2) ?></td>

                    <td class="subtotal">S/. <?= number_format($d['subtotal'],2) ?></td>

                    <td>
                        <a class="btn btn-danger btn-xs"
                           href="php/eliminar_item.php?id=<?= $d['iddet'] ?>&idpedido=<?= $id ?>"
                           onclick="return confirm('Quitar producto?')">
                           <span class="glyphicon glyphicon-trash"></span>
                        </a>
                    </td>
                </tr>
            <?php } ?>

            </tbody>

        </table>
        </div>

        <!-- TOTAL -->
        <h3 class="text-right">
            Total: <b>S/. <span id="total"><?= number_format($pedido['total'],2) ?></span></b>
        </h3>

    </div>
</div>

<!-- ===================== -->
<!-- AGREGAR PRODUCTO -->
<!-- ===================== -->

<div class="panel panel-custom">
    <div class="panel-heading"><b>Agregar Producto</b></div>
    <div class="panel-body">

        <div class="row">
            <div class="col-sm-8">
                <select id="producto" class="form-control">
                    <option value="">-- Seleccione producto --</option>
                    <?php while($pr = $productos->fetch_assoc()){ ?>
                        <option value="<?= $pr['id'] ?>" data-precio="<?= $pr['precio'] ?>">
                            <?= $pr['nombre'] ?> - S/. <?= number_format($pr['precio'],2) ?>
                        </option>
                    <?php } ?>
                </select>
            </div>

            <div class="col-sm-2">
                <input type="number" id="cant_add" class="form-control" min="1" value="1">
            </div>

            <div class="col-sm-2">
                <button type="button" id="btn-add" class="btn btn-success btn-block">
                    <span class="glyphicon glyphicon-plus"></span> Agregar
                </button>
            </div>
        </div>

    </div>
</div>

<!-- BOTON GUARDAR -->
<button class="btn btn-primary btn-lg btn-block">
    <span class="glyphicon glyphicon-floppy-disk"></span> Guardar Cambios
</button>

</form>

</div>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<script>

/// ================================
/// CALCULAR TOTAL EN TIEMPO REAL
/// ================================
$(".cant").on("change", function(){
    recalcularTotales();
});

function recalcularTotales(){
    let total = 0;

    $("#detalle-tabla tr").each(function(){
        var cant = parseFloat($(this).find(".cant").val());
        var precio = parseFloat($(this).find("td:eq(2)").text().replace("S/.",""));
        var sub = cant * precio;

        $(this).find(".subtotal").text("S/. " + sub.toFixed(2));
        total += sub;
    });

    $("#total").text(total.toFixed(2));
}


/// ================================
/// AGREGAR NUEVO PRODUCTO AL DETALLE (SOLO VISUAL)
/// ================================
$("#btn-add").click(function(){

    let idp = $("#producto").val();
    if(idp=="") return alert("Seleccione un producto");

    let nombre = $("#producto option:selected").text();
    let precio = parseFloat($("#producto option:selected").data("precio"));
    let cant = parseFloat($("#cant_add").val());
    let sub = precio * cant;

    let fila = `
        <tr>
            <td>${nombre}</td>
            <td><input type="number" name="nuevo_cant[${idp}]"
                class="form-control input-sm cant" min="1" value="${cant}"></td>
            <td>S/. ${precio.toFixed(2)}</td>
            <td class="subtotal">S/. ${sub.toFixed(2)}</td>
            <td><span class="label label-info">Nuevo</span></td>
        </tr>
    `;

    $("#detalle-tabla").append(fila);
    recalcularTotales();
});
</script>

</body>
</html>
