<?php
include "php/conexion.php";

// TRAER SOLO PEDIDOS LISTOS
$sql = $cn->query("SELECT * FROM pedidos WHERE estado='LISTO' ORDER BY id ASC");

if ($sql->num_rows == 0) {
    echo "<h3 class='text-center text-muted'>No hay pedidos listos para entregar</h3>";
    exit;
}

while ($p = $sql->fetch_assoc()) {

    $idPedido = $p["id"];

    // OBTENER DETALLE DEL PEDIDO
    $det = $cn->query("
        SELECT pr.nombre, d.cantidad
        FROM pedido_detalle d
        INNER JOIN productos pr ON pr.id = d.idproducto
        WHERE d.idpedido = $idPedido
    ");

    echo '<div class="card">';
    
    echo "<div class='card-title'>Pedido #" . $p["id"] . "</div>";

    echo "<b>Cliente:</b> {$p['cliente']}<br>";
    echo "<b>Teléfono:</b> {$p['telefono']}<br>";
    echo "<b>Forma de pago:</b> {$p['modo_pago']}<br>";
    echo "<b>Entrega:</b> {$p['hora_entrega']}<br>";

    echo "<hr><b>Productos:</b><ul>";
    while ($d = $det->fetch_assoc()) {
        echo "<li><b>{$d['cantidad']}×</b> {$d['nombre']}</li>";
    }
    echo "</ul>";

    echo "<h4><b>Total: S/. " . number_format($p["total"], 2) . "</b></h4>";

    echo '
        <a href="php/marcar_entregado.php?id='.$p["id"].'" 
           class="btn btn-primary btn-lg btn-block">
           ✔ Marcar como ENTREGADO
        </a><br>
    ';
    echo '
        <a href="php/anular_pedido.php?id='.$idPedido.'"
           class="btn btn-danger btn-sm"
           onclick="return confirm(\'¿Seguro que deseas ANULAR este pedido?\');">
           ❌ Anular
        </a>
    ';
    echo "</div>";
}
?>

