<?php
include "php/conexion.php";

// OBTENER PEDIDOS PENDIENTES
$sql = $cn->query("SELECT * FROM pedidos WHERE estado='PENDIENTE' ORDER BY id ASC");

if ($sql->num_rows == 0) {
    echo "<h3 class='text-center'>No hay pedidos en preparación</h3>";
    exit;
}

while ($p = $sql->fetch_assoc()) {

    $idPedido = $p["id"];

    // OBTENER DETALLE DEL PEDIDO
    $det = $cn->query("
        SELECT pr.nombre, pr.categoria, d.cantidad, d.subtotal
        FROM pedido_detalle d
        INNER JOIN productos pr ON pr.id = d.idproducto
        WHERE d.idpedido = $idPedido
    ");

    // CALCULAR TOTAL DEL PEDIDO
    $total = 0;
    while ($temp = $det->fetch_assoc()) {
        $total += floatval($temp["subtotal"]);
    }

    // Volvemos a consultar los detalles para listar (porque ya se recorrió una vez)
    $det = $cn->query("
        SELECT pr.nombre, pr.categoria,pr.precio, d.cantidad
        FROM pedido_detalle d
        INNER JOIN productos pr ON pr.id = d.idproducto
        WHERE d.idpedido = $idPedido
    ");
?>
<meta name="viewport" content="width=device-width, initial-scale=1">
<div class="card p-3" style="border: 2px solid #000; margin-bottom: 10px;">
    <h4><b>Nro P-<?= $p["coddia"] ?><br>
        <b>Driver <?= $p["codigo"] ?></b>
    
    </h4>

    <b>Cliente:</b> <?= $p["cliente"] ?><br>
    <b>Teléfono:</b> <?= $p["telefono"] ?><br>
    <b>Forma de pago:</b> <?= $p["modo_pago"] ?><br>
    <b>Entrega:</b> <?= $p["hora_entrega"] ?><br>
    <b>Delivery:</b> <?= "S/. ".$p["costo_delivery"] ?><br>
    <hr>

    <h5><b>Productos:</b></h5>

    <ul style="font-size:18px;">
        <?php
        while ($d = $det->fetch_assoc()) {
            $subtotal = $d['cantidad'] * $d['precio'];
            echo "<li><b>{$d['cantidad']}×</b> {$d['nombre']}— S/ " . number_format($subtotal, 2) . "</li>";
        }
        ?>
    </ul>

    <h4><b>Total: S/. <?= number_format($total+$p["costo_delivery"], 2) ?></b></h4>

    <a href="marcar_listo.php?id=<?= $idPedido ?>" 
       class="btn btn-success btn-lg mt-2">
       ✔ Marcar como LISTO
    </a>
    
    <a href="php/anular_pedido.php?id=<?= $idPedido ?>"
   class="btn btn-danger btn-lg"
   onclick="return confirm('¿Seguro que deseas ANULAR este pedido?');">
   ❌ Anular
</a>

</div>

<?php } ?>

