<?php include "php/conexion.php"; ?>

<?php

// MODO 1: IMPRESIÓN DE PEDIDO INDIVIDUAL
if (isset($_GET["id"]) && is_numeric($_GET["id"])) {

    $id = intval($_GET["id"]);

    // Consultar pedido
    $pedidoSQL = $cn->query("SELECT * FROM pedidos WHERE id = $id");
    if (!$pedidoSQL || $pedidoSQL->num_rows == 0) {
        die("Pedido no encontrado");
    }
    $p = $pedidoSQL->fetch_assoc();
    
    
    // Consultar detalles
    $det = $cn->query("
        SELECT pr.nombre, d.cantidad, d.precio_unitario 
        FROM pedido_detalle d
        INNER JOIN productos pr ON pr.id = d.idproducto
        WHERE d.idpedido = $id
    ");
    
    // CALCULAR TOTAL DEL PEDIDO
    $total = 0;
    while ($temp = $det->fetch_assoc()) {
        $total += floatval($temp["subtotal"]);
    }
    
    // Volvemos a consultar los detalles para listar (porque ya se recorrió una vez)
   $det = $cn->query("
        SELECT pr.nombre, d.cantidad, d.precio_unitario 
        FROM pedido_detalle d
        INNER JOIN productos pr ON pr.id = d.idproducto
        WHERE d.idpedido = $id
   
    ");

    ?>
    <!DOCTYPE html>
    <html>
    <head>
        <meta charset="UTF-8">
        <title>Imprimir Pedido</title>
        
        <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
        <style>
            @media print {
                body {
                    font-size: 12px;
                }
                .container {
                    width: 100%;
                }
            }
        </style>

    </head>

    <body onload="window.print()">

    <div class="container">
        <h3>Driver #<?= $p["codigo"] ?></h3>
        <b>Nro P-<?= $p["coddia"] ?><br>
        <b>Cliente:</b> <?= $p["cliente"] ?><br>
        <b>Teléfono:</b> <?= $p["telefono"] ?><br>
        <b>Pago:</b> <?= $p["modo_pago"] ?><br>
        <b>Entrega:</b> <?= $p["hora_entrega"] ?><br>
       <b>Delivery:</b> <?= "S/. ".$p["costo_delivery"] ?><br>
        <hr>
        <h4>Productos:</h4>
        <ul>
            <?php while($d = $det->fetch_assoc()) { 
              $subtotal = $d['cantidad'] * $d['precio_unitario'];
            ?>
                <li><b><?= $d["cantidad"] ?>×</b> <?= $d["nombre"]."— S/ ". number_format($subtotal, 2); ?></li>
            <?php } ?>
        </ul>
        <h4><b>Total: S/. <?= number_format($total+$p["costo_delivery"], 2) ?></b></h4>
        <script>
        // Cuando se cierre la ventana de impresión → regresar a cocina general
        window.onafterprint = function () {
            window.location = "cocina.php";
        };
        </script>

    </div>

    </body>
    </html>
    <?php
    exit;
}



// ====================
// MODO 2: PANTALLA DE COCINA NORMAL
// ====================
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Pantalla de Cocina</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
   <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
    
    <script>
    // SOLO en modo normal se recargan los pedidos
    function recargar() {
        fetch("cocina_data.php")
        .then(r => r.text())
        .then(html => {
            document.getElementById("contenedor").innerHTML = html;
        });
    }

    setInterval(recargar, 5000);
    window.onload = recargar;
    </script>
</head>

<body>
<div class="container">
    <div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="text-center mt-3">Pedidos Pendientes</h2>
    <a href="logout.php" class="btn btn-outline-danger">
        <i class="bi bi-box-arrow-right"></i> Cerrar sesión
    </a>
    </div>
    <hr>
    <a href="php/volver_panel.php" class="btn btn-default btn-block" style="margin-top:8px;">
        ← Volver al Panel Administrador
      </a>
    <div id="contenedor"></div>
</div>
</body>
</html>
