<?php 
ini_set('display_errors', 1);
error_reporting(E_ALL);
include "php/conexion.php";

// ========================================
// VENTAS DEL DÍA
// ========================================
$sqlVentas = $cn->query("
    SELECT SUM(p.total) AS total 
    FROM pedidos p 
    WHERE DATE(p.fecha) = CURDATE()
");

$rowVentas = $sqlVentas->fetch_assoc();
$ventasHoy = ($rowVentas["total"] != null) ? $rowVentas["total"] : 0;

// ========================================
// PEDIDOS EN PREPARACIÓN
// ========================================
$sqlPrep = $cn->query("SELECT COUNT(*) AS c FROM pedidos WHERE estado='PENDIENTE'");
$rowPrep = $sqlPrep->fetch_assoc();
$prep = $rowPrep["c"];

// ========================================
// PEDIDOS LISTOS
// ========================================
$sqlListo = $cn->query("SELECT COUNT(*) AS c FROM pedidos WHERE estado='LISTO'");
$rowListo = $sqlListo->fetch_assoc();
$listo = $rowListo["c"];

// ========================================
// PEDIDOS ENTREGADOS
// ========================================
$sqlEnt = $cn->query("SELECT COUNT(*) AS c FROM pedidos WHERE estado='ENTREGADO'");
$rowEnt = $sqlEnt->fetch_assoc();
$entregado = $rowEnt["c"];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Panel Administrador</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">
</head>

<body class="container mt-4">

<h2 class="mb-4">Panel Administrador</h2>

<div class="row">

    <!-- Ventas del día -->
    <div class="col-md-4">
        <div class="card text-bg-primary mb-3">
            <div class="card-body">
                <h5 class="card-title">Ventas del día</h5>
                <h3>S/ <?php echo number_format($ventasHoy, 2); ?></h3>
            </div>
        </div>
    </div>

    <!-- Pedidos en preparación -->
    <div class="col-md-4">
        <div class="card text-bg-warning mb-3">
            <div class="card-body">
                <h5 class="card-title">Pedidos en preparación</h5>
                <h3><?php echo $prep; ?></h3>
            </div>
        </div>
    </div>

    <!-- Pedidos listos -->
    <div class="col-md-4">
        <div class="card text-bg-success mb-3">
            <div class="card-body">
                <h5 class="card-title">Pedidos listos</h5>
                <h3><?php echo $listo; ?></h3>
            </div>
        </div>
    </div>

    <!-- Pedidos entregados -->
    <div class="col-md-4">
        <div class="card text-bg-dark mb-3">
            <div class="card-body">
                <h5 class="card-title">Pedidos entregados hoy</h5>
                <h3><?php echo $entregado; ?></h3>
            </div>
        </div>
    </div>

</div>

<hr>

<h4>Accesos rápidos</h4>
<a href="index.php" class="btn btn-warning btn-lg mb-2">➕ Registrar Pedido</a><br>
<a href="listar_productos.php" class="btn btn-primary btn-lg mb-2">Mantenimiento de Productos</a><br>
<a href="reporte_ventas.php" class="btn btn-success btn-lg mb-2">Reporte de Ventas</a><br>
<a href="cocina.php" class="btn btn-danger btn-lg mb-2">Ver pantalla de Cocina</a><br>
<a href="despacho.php" class="btn btn-info btn-lg mb-2">Entregar Pedidos</a>

</body>
</html>
