<?php 
ini_set('display_errors', 1);
error_reporting(E_ALL);
include "php/proteger_admin.php";
include "php/conexion.php";

// ========================================
// VENTAS DEL DÍA
// ========================================
$sqlVentas = $cn->query("
    SELECT SUM(p.total) AS total 
    FROM pedidos p 
    WHERE DATE(p.fecha) = CURDATE() and p.estado<>'ANULADO'
");

$rowVentas = $sqlVentas->fetch_assoc();
$ventasHoy = ($rowVentas["total"] != null) ? $rowVentas["total"] : 0;

// ========================================
// PEDIDOS EN PREPARACIÓN
// ========================================
$sqlPrep = $cn->query("SELECT COUNT(*) AS c FROM pedidos WHERE estado='PENDIENTE'");
$prep = $sqlPrep->fetch_assoc()["c"];

// ========================================
// PEDIDOS LISTOS
// ========================================
$sqlListo = $cn->query("SELECT COUNT(*) AS c FROM pedidos WHERE estado='LISTO'");
$listo = $sqlListo->fetch_assoc()["c"];

// ========================================
// PEDIDOS ENTREGADOS
// ========================================
$sqlEnt = $cn->query("SELECT COUNT(*) AS c FROM pedidos p WHERE estado='ENTREGADO' and DATE(p.fecha) = CURDATE()");
$entregado = $sqlEnt->fetch_assoc()["c"];
?>
<!DOCTYPE html>
<html>
<head>
    <title>Panel Administrador</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- Bootstrap -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

    <style>
        body{
            background:#f4f7fb;
        }

        .card-dashboard {
            border: none;
            border-radius: 15px;
            padding: 20px;
            color: white;
            box-shadow: 0 4px 12px rgba(0,0,0,0.1);
            transition: transform .2s;
        }
        .card-dashboard:hover {
            transform: translateY(-6px);
        }

        .btn-menu {
            border-radius: 12px;
            display: block;
            padding: 15px;
            font-size: 17px;
            font-weight: 600;
            text-align: left;
            box-shadow: 0 3px 10px rgba(0,0,0,0.1);
            transition: transform .2s;
        }
        .btn-menu:hover {
            transform: translateX(5px);
        }
    </style>
</head>

<body class="container mt-4">

<div class="d-flex justify-content-between align-items-center mb-4">

    <h2 class="fw-bold m-0">
        <i class="bi bi-speedometer2"></i> Panel Administrador
    </h2>

    <a href="logout.php" class="btn btn-outline-danger">
        <i class="bi bi-box-arrow-right"></i> Cerrar sesión
    </a>

</div>


<div class="row g-4">

    <!-- Ventas del día -->
    <div class="col-md-3">
        <div class="card-dashboard" style="background:linear-gradient(135deg,#007bff,#0056b3);">
            <h5><i class="bi bi-cash-coin"></i> Ventas del día</h5>
            <h2 class="mt-2">S/ <?php echo number_format($ventasHoy, 2); ?></h2>
        </div>
    </div>

    <!-- Pendientes -->
    <div class="col-md-3">
        <div class="card-dashboard" style="background:linear-gradient(135deg,#f0ad4e,#e69500);">
            <h5><i class="bi bi-hourglass-split"></i> En preparación</h5>
            <h2 class="mt-2"><?php echo $prep; ?></h2>
        </div>
    </div>

    <!-- Listos -->
    <div class="col-md-3">
        <div class="card-dashboard" style="background:linear-gradient(135deg,#28a745,#1e7e34);">
            <h5><i class="bi bi-check-circle"></i> Listos</h5>
            <h2 class="mt-2"><?php echo $listo; ?></h2>
        </div>
    </div>

    <!-- Entregados -->
    <div class="col-md-3">
        <div class="card-dashboard" style="background:linear-gradient(135deg,#343a40,#1d2124);">
            <h5><i class="bi bi-box-seam"></i> Entregados</h5>
            <h2 class="mt-2"><?php echo $entregado; ?></h2>
        </div>
    </div>

</div>

<hr class="my-4">

<h4 class="mb-3 fw-bold"><i class="bi bi-grid"></i> Accesos rápidos</h4>

<div class="row g-3">

    <div class="col-md-6">
        <a href="index.php" class="btn btn-warning btn-menu">
            <i class="bi bi-plus-circle"></i> Registrar Pedido
        </a>
    </div>
    <div class="col-md-6">
        <a href="manpedidos.php" class="btn btn-default btn-menu">
            <i class="bi bi-list"></i> listar Pedidos
        </a>
    </div>

    <div class="col-md-6">
        <a href="listar_productos.php" class="btn btn-primary btn-menu">
            <i class="bi bi-box"></i> Mantenimiento de Productos
        </a>
    </div>

    <div class="col-md-6">
        <a href="cocina.php" class="btn btn-danger btn-menu">
            <i class="bi bi-egg-fried"></i> Ver Pantalla de Cocina
        </a>
    </div>

    <div class="col-md-6">
        <a href="despacho.php" class="btn btn-info btn-menu">
            <i class="bi bi-truck"></i> Entregar Pedidos
        </a>
    </div>
    
    <div class="col-md-6">
        <a href="reporte_ventas.php" class="btn btn-success btn-menu">
            <i class="bi bi-bar-chart-line"></i> Reporte de Ventas
        </a>
    </div>
    <div class="col-md-6">
        <a href="reportes.php" class="btn btn-success btn-menu">
            <i class="bi bi-bar-chart-line"></i> Reporte Grafico
        </a>
    </div>
    <div class="col-md-6">
        <a href="usuarios.php" class="btn btn-info btn-menu">
            <i class="bi bi-person"></i> Registro de Usuarios
        </a>
    </div>

</div>

</body>
</html>
