<?php
require_once("clases/Marca.class.php");
$ObjMarca = new Marcas();

$criterio = isset($_REQUEST['criterio']) ? $_REQUEST['criterio'] : '';
$lista    = $ObjMarca->ListarPorCriterio($criterio);
?>

<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <title>Mantenimiento de Marcas</title>

    <!-- Bootstrap 3 -->
    <link rel="stylesheet"
          href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
</head>

<body>
<div class="container">
<br>
    <!-- ================= REGISTRO ================= -->
    <div class="panel panel-primary">
        <div class="panel-heading">
            <h4 class="panel-title">
                <span class="glyphicon glyphicon-plus"></span>
                Registrar Marca
            </h4>
        </div>

        <div class="panel-body">
            <form class="form-horizontal"
                  method="post"
                  action="controladores/MarcaController.php">

                <input type="hidden" name="txtpara" value="R">

                <div class="form-group">
                    <label class="col-sm-3 control-label">
                        Nombre de Marca
                    </label>
                    <div class="col-sm-6">
                        <input type="text"
                               name="marca"
                               class="form-control"
                               placeholder="Ingrese nombre de la marca"
                               required>
                    </div>
                    <div class="col-sm-3">
                        <button type="submit"
                                class="btn btn-success">
                            <span class="glyphicon glyphicon-floppy-disk"></span>
                            Guardar
                        </button>
                    </div>
                </div>

            </form>
        </div>
    </div>

    <!-- ================= BUSQUEDA ================= -->
    <div class="panel panel-default">
        <div class="panel-body">
            <form class="form-inline" method="get">
                <div class="form-group">
                    <label>Buscar Marca:</label>
                    <input type="text"
                           name="criterio"
                           class="form-control"
                           value="<?php echo $criterio; ?>"
                           placeholder="Ingrese criterio">
                </div>
                <button type="submit" class="btn btn-primary">
                    <span class="glyphicon glyphicon-search"></span>
                    Buscar
                </button>
            </form>
        </div>
    </div>

    <!-- ================= LISTADO ================= -->
    <div class="panel panel-info">
        <div class="panel-heading">
            <h4 class="panel-title">
                <span class="glyphicon glyphicon-list"></span>
                Lista de Marcas
            </h4>
        </div>

        <div class="panel-body">
            <table class="table table-bordered table-hover table-striped">
                <thead>
                    <tr class="info">
                        <th style="width:15%">Código</th>
                        <th>Marca</th>
                        
                    </tr>
                </thead>
                <tbody>
                <?php
                if ($lista != null) {
                    foreach ($lista as $row) {
                ?>
                    <tr>
                        <td><?php echo $row['codmarca']; ?></td>
                        <td><?php echo $row['marca']; ?></td>
                        
                    </tr>
                <?php
                    }
                } else {
                ?>
                    <tr>
                        <td colspan="3" class="text-center text-muted">
                            No se encontraron registros
                        </td>
                    </tr>
                <?php } ?>
                </tbody>
            </table>
        </div>
    </div>

</div>
</body>
</html>
