<?php 
session_start();
session_destroy(); 
?>
<!DOCTYPE html>
<html lang="es">
<head>
<title>Autenticación de Usuarios</title>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">

<!-- Bootstrap 3 -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">

<script src="js/jquery.min.js"></script>
<script src="js/bootstrap.min.js"></script>

<style>
    body {
        min-height: 100vh;
        background: linear-gradient(to right, #06b6d4, #2563eb);
        display: flex;
        flex-direction: column;
        justify-content: space-between;
    }

    .login-card {
        background: rgba(255,255,255,0.9);
        padding: 30px;
        border-radius: 15px;
        box-shadow: 0 8px 25px rgba(0,0,0,0.2);
        max-width: 400px;
        width: 100%;
        animation: fadeUp .6s ease-out;
    }

    @keyframes fadeUp {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .header-bar {
        background: rgba(255,255,255,0.2);
        color: white;
        padding: 6px 0;
        font-weight: bold;
        letter-spacing: 1px;
    }

    footer {
        color: white;
        opacity: .8;
        padding: 10px 0;
        text-align: center;
    }
</style>

<script>
	function validarLogin(f){		
		if( f.user.value.trim() === "" ){			
			alert("Por favor ingrese Nombre de Usuario");
			f.user.focus();		
			return false;
		}
		if( f.pass.value.trim() === "" ){
			alert("Por favor ingrese su Password");
			f.pass.focus();
			return false;
		}
	    return true;
	}
</script>

</head>

<body>

<!-- Barra superior -->
<div class="header-bar text-center">
  SICO - SISTEMA PARA ÓPTICA
</div>

<!-- Contenido -->
<div class="container" style="flex-grow:1; display:flex; justify-content:center; align-items:center;">
    <div class="login-card">

        <div class="text-center">
            <img src="img/LOGOMIRARTE.png" class="img-responsive center-block" style="width:100px; margin-bottom:10px;">
            <h3 class="text-primary" style="font-weight:bold;">Identifíquese para continuar</h3>
        </div>

        <form action="controladores/LoguinController.php" method="POST" onsubmit="return validarLogin(this)">

            <div class="form-group">
                <label>Usuario</label>
                <div class="input-group">
                    <span class="input-group-addon"><i class="glyphicon glyphicon-user"></i></span>
                    <input type="text" name="user" class="form-control" placeholder="Usuario" autofocus>
                </div>
            </div>

            <div class="form-group">
                <label>Contraseña</label>
                <div class="input-group">
                    <span class="input-group-addon"><i class="glyphicon glyphicon-lock"></i></span>
                    <input type="password" name="pass" class="form-control" placeholder="Password">
                </div>
            </div>

            <button type="submit" class="btn btn-primary btn-block" style="font-weight:bold;">
                Iniciar Sesión
            </button>

        </form>

        <p class="text-muted" style="margin-top:15px; text-align:justify;">
            Bienvenido al sistema.
        </p>

    </div>
</div>

<!-- Footer -->
<footer>
  Derechos Reservados Optica Mirarte ©2025
</footer>

</body>
</html>

