<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    function recalcularImporte(index) {
        var precio = parseFloat($(`.precio:eq(${index})`).val());
        var cantidad = parseInt($(`.cantidad:eq(${index})`).val());
        var importe = precio * cantidad;
        $(`#importe_${index}`).val(importe.toFixed(2)); // Actualiza el importe
    }

    function recalcularTotalGeneral() {
        var totalGeneral = 0;
        $('.importe').each(function() {
            totalGeneral += parseFloat($(this).val());
        });
        $('#total_general').val(totalGeneral.toFixed(2)); // Actualiza el total general
    }

    // Escuchar cambios en la cantidad para recalcular el importe
    $('.cantidad').on('input', function() {
        var index = $(this).data('index');
        recalcularImporte(index); // Recalcular el importe para la fila actual
        recalcularTotalGeneral();  // Recalcular el total general
    });

    // Inicialmente, recalcula el total general
    recalcularTotalGeneral();
});
</script>


<form id="formulario">
    <table>
        <thead>
            <tr>
                <th>Producto</th>
                <th>Precio</th>
                <th>Cantidad</th>
                <th>Importe</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Ejemplo de productos
            $productos = [
                ["nombre" => "Producto 1", "precio" => 10],
                ["nombre" => "Producto 2", "precio" => 20],
                ["nombre" => "Producto 3", "precio" => 15]
            ];

            foreach ($productos as $index => $producto) {
                echo "<tr>";
                echo "<td>{$producto['nombre']}</td>";
                echo "<td><input type='number' class='precio' value='{$producto['precio']}' readonly></td>";
                echo "<td><input type='number' class='cantidad' data-index='{$index}' value='1' min='1'></td>";
                echo "<td><input type='text' class='importe' id='importe_{$index}' value='{$producto['precio']}' readonly></td>";
                echo "</tr>";
            }
            ?>
        </tbody>
    </table>

    <br>

    <label>Total General:</label>
    <input type="text" id="total_general" value="0" readonly>

</form>