<?php
require_once("DBManager.class.php");

class Oingresos{
	private $codoi;///
	private $codcliente;
	private $fechaemi;
	private $coddoc;
	private $idestado;
	private $idusuemp;
	private $subtotal;
	private $igv;
	private $total;
	private $numdoc;
	
	public function Correlativo()
	{
		$vCorre2 = 1;		
		$vCont = 1;
		$vCeros = "";
		$delta_ceros = 0;
		$AnoSiguiente = 0;
		$AnoActual = 0;
		$fecha = getdate();
		
		$db= new DBManager();
		$rs=$db->execute("SELECT codoi FROM oingresos ORDER BY codoi;");
		
		//Entra a este bloque si existe algun valor en el campo INroOrd		
		if($rs->lastRow())
		{			
			
		
			$vCorre1 = substr($rs->fields['codoi'],0,5);//variable que almacena los 4 primeros caracteres de INroOrd
			$vCorre2 = substr($rs->fields['codoi'],6); //extraigo los ultimos 5 caracteres de INroOrd 			
			
			$vCorre1 = intval($vCorre1); //obtengo el valor entero
			$vCorre2 = intval($vCorre2); //obtengo el valor entero
							
			$vCorre2++;//se incrementa en 1, es decir el correlativo
			
			//verifico si el correlativo llega a ocupar los 5 digitos
		 	$delta_ceros = 6 - strlen($vCorre2);
			
			if( $delta_ceros == 0 )// Si en el codigo  correlativo ya no existen ceros que poner es decir vCorre2 = 10000
			{
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{

						return ($vCorre1.$vCorre2);
					}			
			}
			
			if( $delta_ceros < 0 /*-1*/)// Si en el codigo correlativo ya no existen ceros que poner y ya llego al limite, en este caso delta_ceros = -1
			{
				$AnoSiguiente = $vCorre1+=1;
				return $AnoSiguiente."0000001";
			}
			
			if( $delta_ceros > 0) // Si en el codigo correlativo existen ceros que poner
			{
			
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{
						for($i=1; $i<$delta_ceros; $i++)
						{
							$vCont++;//contador de ceros
						}			
						$vCeros=str_pad($vCeros,$vCont,'0',STR_PAD_RIGHT);//rellenar de ceros al lado derecho		
						return($vCorre1.$vCeros.$vCorre2);
					}			
			}			

		}else{ 
				//Caso contrario esta vacio el campo al inicio de las acciones				
				return ($fecha['year']."000000".$vCorre2);				
			 }

		$rs->close();
		$db->closeConnection();//opcional			
	}
	/////////////////////////////////////////////////////////////////////////////////////////////////
	public function Num($numero)
	{
		return str_pad($numero, 6, '0', STR_PAD_LEFT);		
	}
	
	public function ObtenerUltimo()
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select numdoc from oingresos order by numdoc desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("numdoc"=> $rs->fields["numdoc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos     
	}	
	/////////////////////////////////////////////////////////////////////////////////////////////
	
	
	
	
	public function Crear($oi,$cc,$fe,$cd,$ie,$iu,$st,$igv,$t,$nd,$obs)
	{
		$resp=false;		
		$db= new DBManager();
		$fe = implode("-", array_reverse(explode("-", $fe)));
		if($db->_execute("INSERT INTO oingresos(codoi,codcliente,fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs) VALUES('".$oi."',".$cc.",'".$fe."','".$cd."',".$ie.",".$iu.",".$st.",".$igv.",".$t.",'".$nd."','".$obs."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}
	
	public function ListarPorCliente($vclt,$u)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where(codcliente = ".$vclt." AND idusuemp=".$u.")");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
public function ListarPorC($vclt)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where(codcliente = ".$vclt.")");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarrPorFecha($vfecha)
	{
	$vector=null;		
		$db= new DBManager();
		$vfecha = implode("-", array_reverse(explode("-", $vfecha)));
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where (fechaemi LIKE CONCAT('%','".$vfecha."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();
	
	}
	////////////////////////////////esto para paginar//////////////
	public function ListarPorCriterio($vid)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where ( codoi LIKE CONCAT('%','".$vid."','%')) ORDER BY codoi DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCriterioven($vid,$u)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where ( DATE(fechaemi) = CURDATE() and idusuemp=".$u.") ORDER BY codoi DESC ;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////////////////////////////////////////////////////777
	public function ListarPorFechausu($vfecha,$u)
	{
		$vector=null;		
		$db= new DBManager();
		//$vfecha = implode("-", array_reverse(explode("-", $vfecha)));
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where ( fechaemi ='".$vfecha."' and idusuemp=".$u.") ORDER BY codoi DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	/////////////////////////////////////////////////////////////////////////
	public function ListarPorDocumento($vid)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where ( coddoc ='".$vid."') ORDER BY codoi DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////para el reporte////////////////////////////////////
	public function ListarPorEstado($x,$y)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where idestado=".$x."  and coddoc='".$y."' ORDER BY codoi DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////////////////////////////////
	public function ListaPaginadaEstado($x,$y,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where ( idestado=".$x."  and coddoc='".$y."' ) ORDER BY codoi DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	/////////////////////////////////////////////////
	public function ListaPaginada($vid,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where ( codoi LIKE CONCAT('%','".$vid."','%') ) ORDER BY codoi DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Filtrar($fechai,$fechaf)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where (fechaemi BETWEEN '".$fechai."' AND '".$fechaf."')");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
		
public function Filtrarven($fechai,$fechaf,$u)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where (fechaemi BETWEEN '".$fechai."' AND '".$fechaf."' AND idusuemp=".$u.")");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codoi"	=> $rs->fields["codoi"],
									"codcliente"	=> $rs->fields["codcliente"],
   			    					"fechaemi" 	=> $rs->fields["fechaemi"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"numdoc" 	=> $rs->fields["numdoc"],
									"obs" 	=> $rs->fields["obs"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}		
		
	public function BuscarPorCodigo($vcod)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select codoi,codcliente,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,coddoc,idestado,idusuemp,subtotal,igv,total,numdoc,obs from oingresos where(codoi = '".$vcod."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->codoi=$rs->fields["codoi"];
				$this->codcliente=$rs->fields["codcliente"];
				$this->fechaemi=$rs->fields["fechaemi"];
				$this->coddoc=$rs->fields["coddoc"];
				$this->idestado=$rs->fields["idestado"];
				$this->idusuemp=$rs->fields["idusuemp"];
				$this->subtotal=$rs->fields["subtotal"];
				$this->igv=$rs->fields["igv"];
				$this->total=$rs->fields["total"];
				$this->numdoc=$rs->fields["numdoc"];
				$this->obs=$rs->fields["obs"];
 				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	
	public function ActualizarMonto($vcod,$vtotal,$vsubtotal)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE oingresos SET total=".$vtotal.", subtotal=".$vsubtotal." WHERE (codoi = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	//////////////////////////////
	public function ActualizarEstadosT($vcod,$videstado)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE oingresos SET idestado = ".$videstado." WHERE (codoi = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	
	//////////////////////////////
	public function Eliminar($vcod)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("DELETE FROM oingresos WHERE (codoi='".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;		
	}								
	
	public function getcodoi(){ return $this->codoi;}
	public function getcodcliente(){ return $this->codcliente;}
	public function getfechaemi(){ return $this->fechaemi;}
	public function getcoddoc(){ return $this->coddoc;}
	public function getidestado(){ return $this->idestado;}
	public function getidusuemp(){ return $this->idusuemp;}
	public function getsubtotal(){ return $this->subtotal;}
	public function getigv(){ return $this->igv;}
	public function gettotal(){ return $this->total;}
	public function getnumdoc(){ return $this->numdoc;}
	public function getobs(){ return $this->obs;}
	
	
}
?>