<?php
/** 
 * Class: Marca.class.php
 * 
 * Esta clase permitir el registro y actualizacin de las marcas 
 * organizacionales de Silicon System SAC						  
 * 
 * @version 	1.0 24/01/2007-Ultima_Modificacion:26/01/2007 
 * @author		Arturo Trigoso. 
 * @copyright	Copyright (c) 2007 Silicon Systems SAC. (http://www.siliconsystems.com)
 */

require_once("DBManager.class.php");

class Tratamiento{
	private $idtrata;
	private $tratamiento;
	private $estado;
	
	public function BuscarPorCodigo($vcodmarc)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select * from tratamiento where (idtrata = ".$vcodmarc.")");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->idtrata=$rs->fields["idtrata"];
   			    $this->tratamiento=$rs->fields["tratamiento"];  
				$this->estado=$rs->fields["estado"];   			    
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function ListarPorCriterio($vnommarc)
	{
		$vector=null;		
		$db= new DBManager();	
		$rs=$db->execute("select * from tratamiento where(tratamiento LIKE CONCAT('%','".$vnommarc."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idtrata"	=> $rs->fields["idtrata"],
   			    					"tratamiento" 	=> $rs->fields["tratamiento"],
									"estado" 	=> $rs->fields["estado"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaPaginada($vpro,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM tratamiento WHERE ( tratamiento LIKE CONCAT('%','".$vpro."','%') ) ORDER BY idtrata ASC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("idtrata"	=> $rs->fields["idtrata"],
   			    					"tratamiento" 	=> $rs->fields["tratamiento"],
									"estado" 	=> $rs->fields["estado"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Crear($vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("INSERT INTO tratamiento(idtrata,tratamiento,estado) VALUES(null,'".$vnommarc."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}	
	
	public function Actualizar($vcod,$vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("update  tratamiento set tratamiento = '".$vnommarc."' where (idtrata=".$vcod.")"))   
		{
			$resp=true;
		}
		return $resp;		
	}	

	public function getidtrata(){ return $this->idtrata;}
	public function gettratamiento(){ return $this->tratamiento;}	
	public function getestado(){ return $this->estado;}	
	
}
?>