<?php
/** 
 * Class: Marca.class.php
 * 
 * Esta clase permitir el registro y actualizacin de las marcas 
 * organizacionales de Silicon System SAC						  
 * 
 * @version 	1.0 24/01/2007-Ultima_Modificacion:26/01/2007 
 * @author		Arturo Trigoso. 
 * @copyright	Copyright (c) 2007 Silicon Systems SAC. (http://www.siliconsystems.com)
 */

require_once("DBManager.class.php");

class Traspaso{
	private $idtras;
	private $codmontura;
	private $idtiendai;
	private $idtiendaf;
	private $fecha;
	
	public function BuscarPorCodigo($vcodmarc)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select * from traspaso where (idtras = ".$vcodmarc.")");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->idtras=$rs->fields["idtras"];
   			    $this->codmontura=$rs->fields["codmontura"]; 
				$this->idtiendai=$rs->fields["idtiendai"];
				$this->idtiendaf=$rs->fields["idtiendaf"]; 
				$this->fecha=$rs->fields["fecha"];  			    
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function ListarPorCriterio($vnommarc)
	{
		$vector=null;		
		$db= new DBManager();	
		$rs=$db->execute("select * from traspaso where(codmontura ='".$vnommarc."'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idtras"	=> $rs->fields["idtras"],
   			    					"codmontura" 	=> $rs->fields["codmontura"],
									"idtiendai" 	=> $rs->fields["idtiendai"],
									"idtiendaf" 	=> $rs->fields["idtiendaf"],
									"fecha" 	=> $rs->fields["fecha"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Listar()
	{
		$vector=null;		
		$db= new DBManager();	
		$rs=$db->execute("select * from traspaso order by idtras desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idtras"	=> $rs->fields["idtras"],
   			    					"codmontura" 	=> $rs->fields["codmontura"],
									"idtiendai" 	=> $rs->fields["idtiendai"],
									"idtiendaf" 	=> $rs->fields["idtiendaf"],
									"fecha" 	=> $rs->fields["fecha"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Filtrar($fechai,$fechaf)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select idtras,codmontura,idtiendai,idtiendaf,DATE_FORMAT(fecha,'%d-%m-%Y') AS fecha from traspaso where fecha BETWEEN '".$fechai."' AND '".$fechaf."'");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("idtras"	=> $rs->fields["idtras"],
   			    					"codmontura" 	=> $rs->fields["codmontura"],
									"idtiendai" 	=> $rs->fields["idtiendai"],
									"idtiendaf" 	=> $rs->fields["idtiendaf"],
									"fecha" 	=> $rs->fields["fecha"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Crear($vnommarc,$idti,$idtf,$f)
	{
		$resp=false;		
		$db= new DBManager();	
		$f = implode("-", array_reverse(explode("-", $f)));		
		if($db->_execute("INSERT INTO traspaso(idtras,codmontura,idtiendai,idtiendaf,fecha) VALUES(null,'".$vnommarc."',".$idti.",".$idtf.",'".$f."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}	
	
		

	public function getidtras(){ return $this->idtras;}
	public function getcodmontura(){ return $this->codmontura;}	
	public function getidtiendai(){ return $this->idtiendai;}
	public function getidtiendaf(){ return $this->idtiendaf;}
	public function gefecha(){ return $this->fecha;}
}
?>