<?php
/** 
 * Class: Marca.class.php
 * 
 * Esta clase permitir el registro y actualizacin de las marcas 
 * organizacionales de Silicon System SAC						  
 * 
 * @version 	1.0 24/01/2007-Ultima_Modificacion:26/01/2007 
 * @author		Arturo Trigoso. 
 * @copyright	Copyright (c) 2007 Silicon Systems SAC. (http://www.siliconsystems.com)
 */

require_once("DBManager.class.php");

class Tipolente{
	private $idtipolente;
	private $tipo;
	private $estado;
	
	public function BuscarPorCodigo($vcodmarc)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select * from tipolente where (idtipolente = ".$vcodmarc.")");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->idtipolente=$rs->fields["idtipolente"];
   			    $this->tipo=$rs->fields["tipo"];  
				$this->estado=$rs->fields["estado"];   			    
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function ListarPorCriterio($vnommarc)
	{
		$vector=null;		
		$db= new DBManager();	
		$rs=$db->execute("select * from tipolente where(tipo LIKE CONCAT('%','".$vnommarc."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idtipolente"	=> $rs->fields["idtipolente"],
   			    					"tipo" 	=> $rs->fields["tipo"],
									"estado" 	=> $rs->fields["estado"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaPaginada($vpro,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM tipolente WHERE ( tipo LIKE CONCAT('%','".$vpro."','%') ) ORDER BY idtipolente ASC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("idtipolente"	=> $rs->fields["idtipolente"],
   			    					"tipo" 	=> $rs->fields["tipo"],
									"estado" 	=> $rs->fields["estado"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Crear($vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("INSERT INTO tipo(idtipolente,tipo,estado) VALUES(null,'".$vnommarc."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}	
	
	public function Actualizar($vcod,$vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("update  tipo set tipo = '".$vnommarc."' where (idtipolente=".$vcod.")"))   
		{
			$resp=true;
		}
		return $resp;		
	}	

	public function getidtipolente(){ return $this->idtipolente;}
	public function gettipo(){ return $this->tipo;}	
	public function getestado(){ return $this->estado;}	
	
}
?>