<?php
/** 
 * Class: Marca.class.php
 * 
 * Esta clase permitir el registro y actualizacin de las marcas 
 * organizacionales de Silicon System SAC						  
 * 
 * @version 	1.0 24/01/2007-Ultima_Modificacion:26/01/2007 
 * @author		Arturo Trigoso. 
 * @copyright	Copyright (c) 2007 Silicon Systems SAC. (http://www.siliconsystems.com)
 */

require_once("DBManager.class.php");

class Productos{
	private $idprod;
	private $producto;
	private $estado;
	
	public function BuscarPorCodigo($vcodmarc)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select * from productos where (idprod = ".$vcodmarc.")");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->idprod=$rs->fields["idprod"];
   			    $this->producto=$rs->fields["producto"];  
				$this->estado=$rs->fields["estado"];   			    
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function ListarTodo()
	{
		$vector=null;		
		$db= new DBManager();	
		$rs=$db->execute("select * from productos");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idprod"	=> $rs->fields["idprod"],
   			    					"producto" 	=> $rs->fields["producto"],
									"estado" 	=> $rs->fields["estado"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaPaginada($vpro,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM productos WHERE ( producto LIKE CONCAT('%','".$vpro."','%') ) ORDER BY idprod ASC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("idprod"	=> $rs->fields["idprod"],
   			    					"producto" 	=> $rs->fields["producto"],
									"estado" 	=> $rs->fields["estado"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Crear($vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("INSERT INTO productos(idprod,producto,estado) VALUES(null,'".$vnommarc."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}	
	
	public function Actualizar($vcod,$vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("update  productos set producto = '".$vnommarc."' where (idprod=".$vcod.")"))   
		{
			$resp=true;
		}
		return $resp;		
	}	

	public function getidprod(){ return $this->idprod;}
	public function getproducto(){ return $this->producto;}	
	public function getestado(){ return $this->estado;}	
	
}
?>