<?php
require_once("DBManager.class.php");

class Ordentrabajo{
	private $codorden;///
	private $numorden;///
	private $codcliente;
	private $fecha_contra;
	private $fecha_entreg;
	private $hora_entreg;
	//private $numerodoc;
	private $coddoc;
	private $idestado; //viene de la tabla estado : cancelado, sin cancelar, anulado, etc
	private $acuenta;
	private $tipopago; //cheque  o efectivo
	private $idusuemp; //cheque  o efectivo
	private $subtotal;
	private $igv;
	private $total;	
	private $obs;	
	private $estadoent;	
	private $numfor;
	private $enrojo;
	private $recep;
	private $fechacanc;
	
	private $nota;
	
	public function Correlativo()
	{
		$vCorre2 = 1;		
		$vCont = 1;
		$vCeros = "";
		$delta_ceros = 0;
		$AnoSiguiente = 0;
		$AnoActual = 0;
		$fecha = getdate();
		
		$db= new DBManager();
		$rs=$db->execute("SELECT codorden FROM ordentrabajo ORDER BY codorden;");
		
		//Entra a este bloque si existe algun valor en el campo INroOrd		
		if($rs->lastRow())
		{			
			
		
			$vCorre1 = substr($rs->fields['codorden'],0,5);//variable que almacena los 4 primeros caracteres de INroOrd
			$vCorre2 = substr($rs->fields['codorden'],6); //extraigo los ultimos 5 caracteres de INroOrd 			
			
			$vCorre1 = intval($vCorre1); //obtengo el valor entero
			$vCorre2 = intval($vCorre2); //obtengo el valor entero
							
			$vCorre2++;//se incrementa en 1, es decir el correlativo
			
			//verifico si el correlativo llega a ocupar los 5 digitos
		 	$delta_ceros = 6 - strlen($vCorre2);
			
			if( $delta_ceros == 0 )// Si en el codigo  correlativo ya no existen ceros que poner es decir vCorre2 = 10000
			{
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{

						return ($vCorre1.$vCorre2);
					}			
			}
			
			if( $delta_ceros < 0 /*-1*/)// Si en el codigo correlativo ya no existen ceros que poner y ya llego al limite, en este caso delta_ceros = -1
			{
				$AnoSiguiente = $vCorre1+=1;
				return $AnoSiguiente."0000001";
			}
			
			if( $delta_ceros > 0) // Si en el codigo correlativo existen ceros que poner
			{
			
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{
						for($i=1; $i<$delta_ceros; $i++)
						{
							$vCont++;//contador de ceros
						}			
						$vCeros=str_pad($vCeros,$vCont,'0',STR_PAD_RIGHT);//rellenar de ceros al lado derecho		
						return($vCorre1.$vCeros.$vCorre2);
					}			
			}			

		}else{ 
				//Caso contrario esta vacio el campo al inicio de las acciones				
				return ($fecha['year']."000000".$vCorre2);				
			 }

		$rs->close();
		$db->closeConnection();//opcional			
	}
	
	public function Num()
	{
		$vCorre=1;		
		$vCont=1;
		$vCeros="";
		$vtipo="0";
		
		$db= new DBManager();	
		$rs=$db->execute("SELECT numerodoc FROM ordentrabajo ORDER BY numerodoc ASC;");		
		if($rs->lastRow()){						
			$vCorre=intval(substr($rs->fields['num'],1));//obtengo el valor entero de la subcadena numerica
			$vCorre++;//se incrementa en 1		
		}
		for($i=1;$i<(6-strlen($vCorre));$i++){
		  $vCont++;//contador de ceros
		}		
		$vCeros=str_pad($vCeros,$vCont,'0',STR_PAD_RIGHT);//rellenar de ceros al lado derecho		
		$rs->close();
		$db->closeConnection();//opcional
		return(strtoupper($vtipo).$vCeros.$vCorre);			
	}
	
	public function Numorden()
	{
		$vCorre2 = 1;		
		$vCont = 1;
		$vCeros = "";
		$delta_ceros = 0;
		$AnoSiguiente = 0;
		$AnoActual = 0; date_default_timezone_set('UTC');
		$fecha = getdate();
		
		$db= new DBManager();
		$rs=$db->execute("SELECT numorden FROM ordentrabajo ORDER BY numorden;");
		
		//Entra a este bloque si existe algun valor en el campo INroOrd		
		if($rs->lastRow())
		{			
			
		
			$vCorre1 = substr($rs->fields['numorden'],0,4);//variable que almacena los 4 primeros caracteres de INroOrd
			$vCorre2 = substr($rs->fields['numorden'],4); //extraigo los ultimos 5 caracteres de INroOrd 			
			
			$vCorre1 = intval($vCorre1); //obtengo el valor entero
			$vCorre2 = intval($vCorre2); //obtengo el valor entero
							
			$vCorre2++;//se incrementa en 1, es decir el correlativo
			
			//verifico si el correlativo llega a ocupar los 5 digitos
		 	$delta_ceros = 2 - strlen($vCorre2);
			
			if( $delta_ceros == 0 )// Si en el codigo  correlativo ya no existen ceros que poner es decir vCorre2 = 10000
			{
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."01";
				}
				else{

						return ($vCorre1.$vCorre2);
					}			
			}
			
			if( $delta_ceros < 0 /*-1*/)// Si en el codigo correlativo ya no existen ceros que poner y ya llego al limite, en este caso delta_ceros = -1
			{
				$AnoSiguiente = $vCorre1+=1;
				return $AnoSiguiente."01";
			}
			
			if( $delta_ceros > 0) // Si en el codigo correlativo existen ceros que poner
			{
			
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."01";
				}
				else{
						for($i=1; $i<$delta_ceros; $i++)
						{
							$vCont++;//contador de ceros
						}			
						$vCeros=str_pad($vCeros,$vCont,'0',STR_PAD_RIGHT);//rellenar de ceros al lado derecho		
						return($vCorre1.$vCeros.$vCorre2);
					}			
			}			

		}else{ 
				//Caso contrario esta vacio el campo al inicio de las acciones				
				return ($fecha['year']."0".$vCorre2);				
			 }

		$rs->close();
		$db->closeConnection();//opcional			
	}
							
	public function Crear($vcoding,$vnumorden,$vcodcliente,$vfecha_contra,$vfecha_entreg,$vhora_ent,$vcoddoc,$videstado,$vacuenta,$vtipopago,$vidusuemp,$vsubtotal,$vigv,$vtotal,$obs,$esp,$numfor,$er,$re,$fc,$nota)
	{
		$resp=false;		
		$db= new DBManager();
		$hora = getdate(); //tomo la fecha actual con todo hora
		$vfecha_contra = implode("-", array_reverse(explode("-", $vfecha_contra)));	
		//$vhora = $hora['hours'].":".$hora['minutes'].":".$hora['seconds'];
		$vfecha_entreg = implode("-", array_reverse(explode("-", $vfecha_entreg)));	
		//$vfeching	= $vfecha_ing." ".$vhora;		
		if($db->_execute("INSERT INTO ordentrabajo(codorden,numorden,codcliente,fecha_contra,fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,fechacanc,nota) VALUES('".$vcoding."','".$vnumorden."',".$vcodcliente.",'".$vfecha_contra."','".$vfecha_entreg."','".$vhora_ent."','".$vcoddoc."',".$videstado.",".$vacuenta.",'".$vtipopago."',".$vidusuemp.",".$vsubtotal.",".$vigv.",".$vtotal.",'".$obs."','".$esp."','".$numfor."','".$er."','".$re."','".$fc."','".$nota."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}
	
	///////////////////
	public function ActualizarOrdenT($vcod,$cc,$fe,$he,$doc,$ep,$tp,$obs,$ee,$nf,$er)
	{
		$resp=false;		
		$db= new DBManager();
		$fe = implode("-", array_reverse(explode("-", $fe)));	
if($db->_execute("UPDATE ordentrabajo SET codcliente=".$cc.",fecha_entreg='".$fe."',hora_ent='".$he."',coddoc='".$doc."',idestado = ".$ep.",tipopago='".$tp."', obs='".$obs."', estadoent='".$ee."', numfor='".$nf."', enrojo='".$er."' WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	
	public function ListarPorCliente($vclt)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where(codcliente = ".$vclt.") order by codorden desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	public function ListarPorUsuario($vclt)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where(idusuemp = ".$vclt.") order by fecha_contra desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	public function ListarPorCobrarCliente($vclt)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where(codcliente = ".$vclt." and idestado='2') order by fecha_contra desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////////
	public function ListarPorCriterio()
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo order by codorden desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCriterioven($usu)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where idusuemp=".$usu." order by codorden desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	//////////////////////////7777777777
	
	public function ListarPorFecha($vfecha_ing)
	{
	$vector=null;		
		$db= new DBManager();
		$vfecha_ing = implode("-", array_reverse(explode("-", $vfecha_ing)));
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where(fecha_contra ='".$vfecha_ing."') order by fecha_contra desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();
	
	}
	
	public function ListarPorFechaven($vfecha_ing,$usu)
	{
	$vector=null;		
		$db= new DBManager();
		//$vfecha_ing = implode("-", array_reverse(explode("-", $vfecha_ing)));
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where(fecha_contra ='".$vfecha_ing."' and idusuemp=".$usu." and idestado<3) order by fecha_contra desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();
	
	}
	
	
	////////////////////////////////esto para paginar//////////////
	public function ListarPorNumOrden($vid)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where(numorden ='".$vid."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	/////////////////////////////////////////////////////////////////////////
	public function ListarPorDocumento($vid)// para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where ( coddoc LIKE CONCAT('%','".$vid."','%')) ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////para el reporte////////////////////////////////////
	public function ListarPorEstadoP($x) // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where idestado=".$x." ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorEstadoPven($x,$usu) // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where idestado=".$x." and idusuemp=".$usu." ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorEstadoEnt($x) // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where estadoent='".$x."' ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorEstadoEntven($x,$usu) // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where estadoent='".$x."' and idusuemp=".$usu." ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCancelar() // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where idestado=2 ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCancelarven($usu) // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where idestado='2' and idusuemp=".$usu." ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarEnrojo($usu) // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where enrojo='SI' and idusuemp=".$usu." ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarEnrojono($usu,$f) // para reportes
	{
		$vector=null;		
		$db= new DBManager('opticaco_marlene','colmena2013'); $f = implode("-", array_reverse(explode("-", $f)));	
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where enrojo='NO' and idusuemp=".$usu." and fecha_contra='".$f."' and idestado<3 ORDER BY codorden DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarCancelados($f,$ff) // para reportes
	{
		$vector=null;		
		$db= new DBManager('opticaco_marlene','colmena2013');
		$f = implode("-", array_reverse(explode("-", $f)));
		$ff = implode("-", array_reverse(explode("-", $ff)));
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra BETWEEN '".$f."' AND '".$ff."' AND idestado=1;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////////////////////////////////
	public function ListaPaginadaEstado($x,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where ( estadopago='".$x."') ORDER BY codorden DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	/////////////////////////////////////////////////
	public function ListaPaginada($vid,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where ( codorden LIKE CONCAT('%','".$vid."','%')) ORDER BY codorden DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaPaginada2($vid,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where ( codorden LIKE CONCAT('%','".$vid."','%') and idestado='2') ORDER BY codorden DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	public function Filtrar($fechai,$fechaf)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra BETWEEN '".$fechai."' AND '".$fechaf."' AND estadoent='NO'");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	public function Filtrarven($fechai,$fechaf,$usu)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra BETWEEN '".$fechai."' AND '".$fechaf."' AND estadoent='NO' AND idusuemp=".$usu."");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	public function Filtrar2($fechai,$fechaf)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra BETWEEN '".$fechai."' AND '".$fechaf."' AND estadoent='SI'");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	public function FiltrarComision($fechai,$fechaf,$usu)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fechacanc BETWEEN '".$fechai."' AND '".$fechaf."' AND idusuemp=".$usu." AND idestado=1");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	public function Filtrarven2($fechai,$fechaf,$usu)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra BETWEEN '".$fechai."' AND '".$fechaf."' AND estadoent='SI' AND idusuemp=".$usu."");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	
	public function FiltrarPordia($fechaf)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		//$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra ='".$fechaf."' AND estadoent='NO'");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	public function FiltrarPordiaven($fechaf,$usu)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		//$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra ='".$fechaf."' AND estadoent='NO' and idusuemp=".$usu."");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	
	public function FiltrarPordiaE($fechaf)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		//$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra ='".$fechaf."' AND estadoent='SI'");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
	
	public function FiltrarPordiaEven($fechaf,$usu)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		//$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc from ordentrabajo where fecha_contra ='".$fechaf."' AND estadoent='SI' AND idusuemp=".$usu."");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
								"codcliente" 	=> $rs->fields["codcliente"],
   			    				"fecha_contra" 	=> $rs->fields["fecha_contra"],
								"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
		
	public function BuscarPorCodigo($vcod)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc,nota from ordentrabajo where(codorden = '".$vcod."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->codorden=$rs->fields["codorden"];
				$this->numorden=$rs->fields["numorden"];
				$this->codcliente=$rs->fields["codcliente"];
				$this->fecha_contra=$rs->fields["fecha_contra"];
				$this->fecha_entreg=$rs->fields["fecha_entreg"];
				$this->hora_ent=$rs->fields["hora_ent"];
				$this->coddoc=$rs->fields["coddoc"];
				$this->idestado=$rs->fields["idestado"];
				$this->acuenta=$rs->fields["acuenta"];
				$this->tipopago=$rs->fields["tipopago"];
				$this->idusuemp=$rs->fields["idusuemp"];
				$this->subtotal=$rs->fields["subtotal"];
				$this->igv=$rs->fields["igv"];
				$this->total=$rs->fields["total"];
				$this->obs=$rs->fields["obs"];
				$this->estadoent=$rs->fields["estadoent"];
				$this->numfor=$rs->fields["numfor"];
				$this->enrojo=$rs->fields["enrojo"];
				$this->recep=$rs->fields["recep"];
				$this->fechacanc=$rs->fields["fechacanc"];
				$this->nota=$rs->fields["nota"];
 				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function ListarClientesColmena()
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM `ordentrabajo`,`cliente` WHERE `ordentrabajo`.`codcliente`=`cliente`.`codcliente` AND `idusuemp`=12 order by codorden desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"],
									"nombres" 	=> $rs->fields["nombres"],
									"telefono" 	=> $rs->fields["telefono"],
									"direccion" 	=> $rs->fields["direccion"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaPaginadacolmena($vid,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codorden,numorden,codcliente,DATE_FORMAT(fecha_contra,'%d-%m-%Y') AS fecha_contra,DATE_FORMAT(fecha_entreg,'%d-%m-%Y') AS fecha_entreg,hora_ent,coddoc,idestado,acuenta,tipopago,idusuemp,subtotal,igv,total,obs,estadoent,numfor,enrojo,recep,DATE_FORMAT(fechacanc,'%d-%m-%Y') AS fechacanc,nombres,telefono,direccion from ordentrabajo,cliente  where ( codorden LIKE CONCAT('%','".$vid."','%') and ordentrabajo.codcliente = cliente.codcliente and iddusuemp=12) ORDER BY codorden DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codorden"	=> $rs->fields["codorden"],
									"numorden"	=> $rs->fields["numorden"],
									"codcliente" 	=> $rs->fields["codcliente"],
   			    					"fecha_contra" 	=> $rs->fields["fecha_contra"],
									"fecha_entreg" 	=> $rs->fields["fecha_entreg"],
									"hora_ent" 	=> $rs->fields["hora_ent"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"],
									"obs" 	=> $rs->fields["obs"],
									"estadoent" 	=> $rs->fields["estadoent"],
									"numfor" 	=> $rs->fields["numfor"],
									"enrojo" 	=> $rs->fields["enrojo"],
									"recep" 	=> $rs->fields["recep"],
									"fechacanc" 	=> $rs->fields["fechacanc"],
									"nombres" 	=> $rs->fields["nombres"],
									"telefono" 	=> $rs->fields["telefono"],
									"direccion" 	=> $rs->fields["direccion"]
									);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	
	public function ActualizarMonto($vcod,$vtotal,$vsubtotal)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE ordentrabajo SET subtotal = ".$vsubtotal.", total=".$vtotal." WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}

	
	public function ActualizarMontoAnulado($vcod,$vtotal,$vsubtotal,$vade)
	{
		$resp=false;		
		$db= new DBManager();	
		if($db->_execute("UPDATE ordentrabajo SET subtotal = ".$vsubtotal.", total=".$vtotal.", acuenta=".$vade." WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	//////////////////////////////
	public function ActualizarEstadosT($vcod,$vestadopago)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE ordentrabajo SET idestado = ".$vestadopago." WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;		
	}
	public function ActualizarFechacanc($vcod,$fc)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE ordentrabajo SET fechacanc = ".$fc." WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;		
	}
	
	public function ActualizarEstadoEnt($vcod,$vestadopago)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE ordentrabajo SET estadoent = ".$vestadopago." WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	
	
	public function ActualizarRojos($vcod,$ves)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE ordentrabajo SET enrojo = '".$ves."' WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	
	public function ActualizarAcuenta($vcod,$ves)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE ordentrabajo SET acuenta = ".$ves." WHERE (codorden = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	
	public function generarNumfor($idusuemp) 
			{
				$vector = null;		
				$db = new DBManager();			
				// Consulta para obtener el siguiente numfor para el usuario
				$consulta = "SELECT COALESCE(MAX(numfor), 0) + 1 AS siguiente_numfor
                                FROM ordentrabajo
                                WHERE idusuemp = $idusuemp
                                ORDER BY codorden DESC
                                LIMIT 1;";			
				$rs = $db->execute($consulta); 
				$num_rows = $rs->getNumOfRows();			
				if ($num_rows > 0) {
					$rs->firstRow(); // opcional, si tu objeto lo requiere
					while (!$rs->EOF) {
						$vector[] = array("siguiente_numfor" => $rs->fields["siguiente_numfor"]);
						$rs->nextRow(); // avanzar al siguiente
					}
					return $vector;
				} else {
					return null;
				}			
				$rs->close(); 
				$db->closeConnection(); // opcional
			}
	
	/*/////////////////////////////
	public function Eliminar($vcod)
	{
		$resp=false;		
		$db= new DBManager('opticaco_marlene','colmena2013');
		if($db->_execute("DELETE FROM pedido WHERE (idpedido='".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;		
	}	*/							
	
	public function getcodorden(){ return $this->codorden;}
	public function getNumorden(){ return $this->numorden;}
	public function getCodcliente(){ return $this->codcliente;}
	public function getFecha_contra(){ return $this->fecha_contra;}
	public function getFecha_entreg(){ return $this->fecha_entreg;}
	public function getHora_ent(){ return $this->hora_ent;}
	//public function getNumerodoc(){ return $this->numerodoc;}
	public function getCoddoc(){ return $this->coddoc;}
	public function getIdestado(){ return $this->idestado;}
	public function getAcuenta(){ return $this->acuenta;}
	public function getTipopago(){ return $this->tipopago;}
	public function getIdusuemp(){ return $this->idusuemp;}
	public function getSubtotal(){ return $this->subtotal;}
	public function getIgv(){ return $this->igv;}
	public function getTotal(){ return $this->total;}
	public function getObs(){ return $this->obs;}
	public function getEstadoent(){ return $this->estadoent;}
	public function getNumfor(){ return $this->numfor;}
	public function getEnrojo(){ return $this->enrojo;}
	public function getRecep(){ return $this->recep;}
	public function getFechacanc(){ return $this->fechacanc;}
	public function getnota(){ return $this->nota;}
}
?>