<?php

require_once("DBManager.class.php");

class Montura{
	private $codmontura ;///
	private $tipo;
	private $marca;
	private $coduni ;
	private $color;
	private $pventa;
	private $freg;
	private $fsal;	
	private $recibo;
	private $idtienda;
	private $fing;
	///////////////////////////////////////
	public function Correlativo()
	{
		$vCorre2 = 1;		
		$vCont = 1;
		$vCeros = "";
		$delta_ceros = 0;
		$AnoSiguiente = 0;
		$AnoActual = 0;
		$fecha = getdate();
		
		$db= new DBManager();
		$rs=$db->execute("SELECT codmontura FROM montura ORDER BY codmontura;");
		
		//Entra a este bloque si existe algun valor en el campo INroOrd		
		if($rs->lastRow())
		{			
			
		
			$vCorre1 = substr($rs->fields['codmontura'],0,5);//variable que almacena los 4 primeros caracteres de INroOrd
			$vCorre2 = substr($rs->fields['codmontura'],6); //extraigo los ultimos 5 caracteres de INroOrd 			
			
			$vCorre1 = intval($vCorre1); //obtengo el valor entero
			$vCorre2 = intval($vCorre2); //obtengo el valor entero
							
			$vCorre2++;//se incrementa en 1, es decir el correlativo
			
			//verifico si el correlativo llega a ocupar los 5 digitos
		 	$delta_ceros = 6 - strlen($vCorre2);
			
			if( $delta_ceros == 0 )// Si en el codigo  correlativo ya no existen ceros que poner es decir vCorre2 = 10000
			{
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{

						return ($vCorre1.$vCorre2);
					}			
			}
			
			if( $delta_ceros < 0 /*-1*/)// Si en el codigo correlativo ya no existen ceros que poner y ya llego al limite, en este caso delta_ceros = -1
			{
				$AnoSiguiente = $vCorre1+=1;
				return $AnoSiguiente."0000001";
			}
			
			if( $delta_ceros > 0) // Si en el codigo correlativo existen ceros que poner
			{
			
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{
						for($i=1; $i<$delta_ceros; $i++)
						{
							$vCont++;//contador de ceros
						}			
						$vCeros=str_pad($vCeros,$vCont,'0',STR_PAD_RIGHT);//rellenar de ceros al lado derecho		
						return($vCorre1.$vCeros.$vCorre2);
					}			
			}			

		}else{ 
				//Caso contrario esta vacio el campo al inicio de las acciones				
				return ($fecha['year']."000000".$vCorre2);				
			 }

		$rs->close();
		$db->closeConnection();//opcional			
	}
	
	
	public function Crear($cod,$vtipo,$vmarca,$vcoduni,$vcolor,$pventa,$vfreg,$vfsal,$vrecibo,$vit,$fing)
	{
		$resp=false;		
		$db= new DBManager();
		$vfreg = implode("-", array_reverse(explode("-", $vfreg)));
		$vfsal = implode("-", array_reverse(explode("-", $vfsal)));		
		//$fing = implode("-", array_reverse(explode("-", $fing)));		
		if($db->_execute("INSERT INTO montura(codmontura,tipo,marca,coduni,color,pventa,freg,fsal,recibo,idtienda,fing) VALUES('".$cod."','".$vtipo."','".$vmarca."','".$vcoduni."','".$vcolor."',".$pventa.",'".$vfreg."','".$vfsal."','".$vrecibo."',".$vit.",'".$fing."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}
	
	
	public function ListarPorMarca($vproducto)
	{
		$vector=null;		
		$db= new DBManager();		
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(marca LIKE CONCAT('%','".$vproducto."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	
	
	public function ListarPorTienda($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and fsal='0000-00-00') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}


public function ListarPorTiendaDisTipo($vl,$t)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and freg='0000-00-00' and tipo='".$t."') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
public function ListarPorTiendaDisTipoTarifaEco($vl,$t)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and freg='0000-00-00' and tipo='".$t."' and pventa<300) order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
public function ListarPorTiendaDisTipoTarifaExclu($vl,$t)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and freg='0000-00-00' and tipo='".$t."' and pventa>=500) order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorTiendaDis($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and freg='0000-00-00') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorTiendaStock($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and recibo='0') order by recibo");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorTiendaStockven($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and recibo=0) order by marca");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorTiendaMarca($vl,$m)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where (idtienda =".$vl." and marca='".$m."') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	
	public function ListarPorTiendaMarcaStock($vl,$m)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and marca='".$m."' and freg='0000-00-00') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorTiendaconOrden($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(idtienda =".$vl." and recibo<>'0' and freg<>'0000-00-00') order by coduni");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	
	////////////////////////////////////////
		
	public function BuscarPorCodigo($vcod)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where(codmontura = '".$vcod."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->codmontura=$rs->fields["codmontura"];
				$this->tipo=$rs->fields["tipo"];				 
				$this->marca=$rs->fields["marca"];
				$this->coduni=$rs->fields["coduni"];
				$this->color=$rs->fields["color"];
				$this->pventa=$rs->fields["pventa"];
				$this->freg=$rs->fields["freg"];
				$this->fsal=$rs->fields["fsal"];
				$this->recibo=$rs->fields["recibo"];
				$this->idtienda=$rs->fields["idtienda"];
				$this->fing=$rs->fields["fing"];
 				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function BuscarPorCoduniDis($vcod)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where (coduni ='$vcod' and freg='0000-00-00') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->codmontura=$rs->fields["codmontura"];
				$this->tipo=$rs->fields["tipo"];				 
				$this->marca=$rs->fields["marca"];
				$this->coduni=$rs->fields["coduni"];
				$this->color=$rs->fields["color"];
				$this->pventa=$rs->fields["pventa"];
				$this->freg=$rs->fields["freg"];
				$this->fsal=$rs->fields["fsal"];
				$this->recibo=$rs->fields["recibo"];
				$this->idtienda=$rs->fields["idtienda"];
				$this->fing=$rs->fields["fing"];
 				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	
	public function Actualizar($vcod,$vtipo,$vmarca,$vcoduni,$vcolor,$vpventa,$vfreg,$vfsal,$vrecibo,$vi,$fi)			
	{
		$resp=false;		
		$db= new DBManager();
		$vfreg = implode("-", array_reverse(explode("-", $vfreg)));
		$vfsal = implode("-", array_reverse(explode("-", $vfsal)));		
		$fi = implode("-", array_reverse(explode("-", $fi)));		
		if($db->_execute("update montura set tipo = '".$vtipo."', marca='".$vmarca."',coduni='".$vcoduni."', color ='".$vcolor."', pventa=".$vpventa.",freg='".$vfreg."', fsal='".$vfsal."', recibo = '".$vrecibo."', idtienda = ".$vi.", fing='".$fi."' where (codmontura='".$vcod."')"))//si es exitosa la consulta			   
		{
		  $resp=true; 
		}	
		return $resp;
	}

	public function ActualizarFechaRecibo($vcod,$vfreg,$vrecibo)			
	{
		$resp=false;		
		$db= new DBManager();
		$vfreg = implode("-", array_reverse(explode("-", $vfreg)));	
		if($db->_execute("update montura set freg='".$vfreg."', recibo = '".$vrecibo."' where (codmontura='".$vcod."')"))//si es exitosa la consulta			   
		{
		  $resp=true; 
		}	
		return $resp;
	}
	
	public function ActualizarFechaEntrega($vcod,$vfsal)			
	{
		$resp=false;		
		$db= new DBManager();		
		$vfsal = implode("-", array_reverse(explode("-", $vfsal)));			
		if($db->_execute("update montura set fsal='".$vfsal."' where (codmontura='".$vcod."')"))//si es exitosa la consulta			   
		{
		  $resp=true; 
		}	
		return $resp;
	}
	
	public function Traspasar($vcod,$idtienda,$vfing)			
	{
		$resp=false;		
		$db= new DBManager();		
		$vfing = implode("-", array_reverse(explode("-", $vfing)));			
		if($db->_execute("update montura set fing='".$vfing."',idtienda=".$idtienda." where (codmontura='".$vcod."')"))//si es exitosa la consulta			   
		{
		  $resp=true; 
		}	
		return $resp;
	}
	/////////////////////////////////*/
		
	public function ListaTotal()
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaTotalT($t)
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where idtienda=".$t." and  freg='0000-00-00' order by marca");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarSinRecibo()
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where (recibo='0' and freg='0000-00-00') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	/*
	public function Listarpocos($fsal)
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select * from producto where (fsal<=".$fsal." and tipo <> 1)");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"des"=> $rs->fields["des"],
									"ubicacion"=> $rs->fields["ubicacion"],
									"pcompra"=> $rs->fields["pcompra"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"stock"=> $rs->fields["stock"],
									"recibo"=> $rs->fields["recibo"],
									"img"=> $rs->fields["img"]
									);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}*/
	//////////////////////////////
	public function ListarPorCodigo($vcod,$u)
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where (coduni ='".$vcod."' and idtienda=".$u." and freg='0000-00-00') order by marca"); //and freg='0000-00-00'
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
public function ListarPorFing($vfing,$u)
	{
		$vector=null;
		$db= new DBManager();
		$vfing = implode("-", array_reverse(explode("-", $vfing)));
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where (fing ='".$vfing."' and idtienda=".$u.") order by marca");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCodigoDis($vcod)
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where (coduni ='".$vcod."' and freg='0000-00-00') order by idtienda");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	////////////////////////////
	public function ListaPaginada($vpro,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();			
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura WHERE (coduni ='".$vpro."') ORDER BY idtienda ASC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	public function ListaTotalPaginada($crit,$t,$limitInf,$tampag)
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select codmontura,tipo,marca,coduni,color,pventa,DATE_FORMAT(freg,'%d-%m-%Y') as freg,DATE_FORMAT(fsal,'%d-%m-%Y') as fsal,recibo,idtienda,DATE_FORMAT(fing,'%d-%m-%Y') as fing from montura where coduni LIKE CONCAT('%','".$crit."','%')  and idtienda=".$t." and fsal='0000-00-00' order by codmontura DESC limit ".$limitInf.",".$tampag.";");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("codmontura"	=> $rs->fields["codmontura"],   			    					
									"tipo"=> $rs->fields["tipo"],
									"marca"=> $rs->fields["marca"],
									"coduni"=> $rs->fields["coduni"],
									"color"=> $rs->fields["color"],
									"pventa"=> $rs->fields["pventa"],
									"freg"=> $rs->fields["freg"],
									"fsal"=> $rs->fields["fsal"],
									"recibo"=> $rs->fields["recibo"],
									"idtienda"=> $rs->fields["idtienda"],
									"fing"=> $rs->fields["fing"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}

	////////////////////////////////////////							
	
	public function getcodmontura(){ return $this->codmontura;}
	public function gettipo(){ return $this->tipo;}
	public function getmarca(){ return $this->marca;}
	public function getcoduni(){ return $this->coduni;}
	public function getcolor(){ return $this->color;}
	public function getpventa(){ return $this->pventa;}
	public function getfreg(){ return $this->freg;}
	public function getfsal(){ return $this->fsal;}
	public function getrecibo(){ return $this->recibo;}
	public function getidtienda(){ return $this->idtienda;}
	public function getfing(){ return $this->fing;}
					
}
?>