<?php
/** 
 * Class: Marca.class.php
 * 
 * Esta clase permitir el registro y actualizacin de las marcas 
 * organizacionales de Silicon System SAC						  
 * 
 * @version 	1.0 24/01/2007-Ultima_Modificacion:26/01/2007 
 * @author		Arturo Trigoso. 
 * @copyright	Copyright (c) 2007 Silicon Systems SAC. (http://www.siliconsystems.com)
 */

require_once("DBManager.class.php");

class Marcas{
	private $codmarca;
	private $marca;
	
	public function BuscarPorCodigo($vcodmarc)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select * from marcas where (codmarca = '".$vcodmarc."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->codmarca=$rs->fields["codmarca"];
   			    $this->marca=$rs->fields["marca"];   			    
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function ListarPorCriterio($vnommarc)
	{
		$vector=null;		
		$db= new DBManager();		
		$rs=$db->execute("select * from marcas where(marca LIKE CONCAT('%','".$vnommarc."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("codmarca"	=> $rs->fields["codmarca"],
   			    					"marca" 	=> $rs->fields["marca"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaPaginada($vpro,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();	
		$rs=$db->execute("SELECT * FROM marcas WHERE ( marca LIKE CONCAT('%','".$vpro."','%') ) ORDER BY codmarca ASC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("codmarca"=> $rs->fields["codmarca"],   			    				
									"marca"=> $rs->fields["marca"]);
									
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Crear($codmarca,$vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("INSERT INTO marcas(codmarca,marca) VALUES('".$codmarca."','".$vnommarc."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}	
	
	public function Actualizar($vcod,$vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("update  marcas set marca = '".$vnommarc."' where (codmarca=".$vcod.")"))   
		{
			$resp=true;
		}
		return $resp;		
	}	

	public function getCodmarca(){ return $this->codmarca;}
	public function getMarca(){ return $this->marca;}	
	
}
?>