<?php

require_once("DBManager.class.php");

class Lente{
	private $idlente;///
	private $idcat;
	private $marca;
	private $tipo ;
	private $probvi_model;
	private $modelo;
	private $cilindro;
	private $cilin;
	private $diametro;
	private $altura;	
	private $calidad;
	private $color;
	private $mi;
	private $mf;
	private $precio;
	///////////////////////////////////////
	public function Correlativo()
	{
		$vCorre2 = 1;		
		$vCont = 1;
		$vCeros = "";
		$delta_ceros = 0;
		$AnoSiguiente = 0;
		$AnoActual = 0;
		$fecha = getdate();
		
		$db= new DBManager();
		$rs=$db->execute("SELECT idlente FROM lente ORDER BY idlente;");
		
		//Entra a este bloque si existe algun valor en el campo INroOrd		
		if($rs->lastRow())
		{			
			
		
			$vCorre1 = substr($rs->fields['idlente'],0,5);//variable que almacena los 4 primeros caracteres de INroOrd
			$vCorre2 = substr($rs->fields['idlente'],6); //extraigo los ultimos 5 caracteres de INroOrd 			
			
			$vCorre1 = intval($vCorre1); //obtengo el valor entero
			$vCorre2 = intval($vCorre2); //obtengo el valor entero
							
			$vCorre2++;//se incrementa en 1, es decir el correlativo
			
			//verifico si el correlativo llega a ocupar los 5 digitos
		 	$delta_ceros = 6 - strlen($vCorre2);
			
			if( $delta_ceros == 0 )// Si en el codigo  correlativo ya no existen ceros que poner es decir vCorre2 = 10000
			{
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{

						return ($vCorre1.$vCorre2);
					}			
			}
			
			if( $delta_ceros < 0 /*-1*/)// Si en el codigo correlativo ya no existen ceros que poner y ya llego al limite, en este caso delta_ceros = -1
			{
				$AnoSiguiente = $vCorre1+=1;
				return $AnoSiguiente."0000001";
			}
			
			if( $delta_ceros > 0) // Si en el codigo correlativo existen ceros que poner
			{
			
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{
						for($i=1; $i<$delta_ceros; $i++)
						{
							$vCont++;//contador de ceros
						}			
						$vCeros=str_pad($vCeros,$vCont,'0',STR_PAD_RIGHT);//rellenar de ceros al lado derecho		
						return($vCorre1.$vCeros.$vCorre2);
					}			
			}			

		}else{ 
				//Caso contrario esta vacio el campo al inicio de las acciones				
				return ($fecha['year']."000000".$vCorre2);				
			 }

		$rs->close();
		$db->closeConnection();//opcional			
	}
	
	
	public function Crear($idlente,$idcat,$marca,$tipo,$probvi_model,$modelo,$cilindro,$cilin,$diametro,$altura,$calidad,$color,$mi,$mf,$precio)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("INSERT INTO lente(idlente,idcat,marca,tipo,probvi_model,modelo,cilindro,cilin,diametro,altura,calidad,color,mi,mf,precio) VALUES('".$idlente."',".$idcat.",'".$marca."','".$tipo."','".$probvi_model."','".$modelo."',".$cilindro.",".$cilin.",'".$diametro."','".$altura."','".$calidad."','".$color."',".$mi.",".$mf.",".$precio.")"))   
		{
			$resp=true;
		}
		return $resp;		
	}
	
	
	public function ListarPorCategoria($idcat)
	{
		$vector=null;		
		$db= new DBManager();		
		$rs=$db->execute("select * from lente where(idcat LIKE CONCAT('%','".$idcat."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCategoriaCalidad($idcat,$cal)
	{
		$vector=null;		
		$db= new DBManager();		
		$rs=$db->execute("select * from lente where (idcat=".$idcat." and calidad='".$cal."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCategoriaTipo($idcat,$tipo)
	{
		$vector=null;		
		$db= new DBManager();		
		$rs=$db->execute("select * from lente where (idcat=".$idcat." and tipo='".$tipo."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorTipo($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select * from lente where(tipo ='".$vl."') order by idlente");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorProbvisual($vl,$m)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select * from lente where(probvi_model ='".$vl."' and modelo='".$m."') order by idlente");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCilindro($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select * from lente where(".$vl." BETWEEN `lente`.`cilindro` AND  `lente`.`cilin`) order by idlente");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorEsfCilCali($es,$cil,$cali)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT `lente`.`idlente`,`lente`.`idcat`,`lente`.`marca`,`lente`.`tipo`,`lente`.`probvi_model`,`lente`.`modelo`, `lente`.`cilindro`,`lente`.`cilin`,`lente`.`diametro`,`lente`.`altura`,`lente`.`calidad`,`lente`.`color`,`lente`.`mi`,`lente`.`mf`,`lente`.`precio`, `lente`.`cilindro` FROM `lente` WHERE (".$es." BETWEEN `lente`.`mi` AND  `lente`.`mf`) AND (".$cil." BETWEEN `lente`.`cilindro` AND  `lente`.`cilin`) AND `lente`.`calidad` = '".$cali."'");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCTCEC($cat,$tipo,$cal,$es,$cil) //lista por los cuatro parametros
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM lente WHERE (".$es." BETWEEN mi AND  mf) AND (".$cil." BETWEEN cilindro AND  cilin) AND calidad = '".$cal."' AND idcat = ".$cat." AND tipo = '".$tipo."' AND probvi_model='COMBINADO'");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}

public function ListarPorCTCME($cat,$tipo,$cal,$es,$cil) //lista por los cuatro parametros
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM lente WHERE (".$es." BETWEEN mi AND  mf) AND (".$cil." BETWEEN cilindro AND  cilin) AND calidad = '".$cal."' AND idcat = ".$cat." AND tipo = '".$tipo."'");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCTCE($cat,$tipo,$cal,$es) //lista por los cuatro parametros
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM lente WHERE (".$es." BETWEEN mi AND mf) AND calidad = '".$cal."' AND idcat = ".$cat." AND tipo = '".$tipo."' AND probvi_model='ESFERICO'");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	public function ListarPorCTCC($cat,$tipo,$cal,$cil) //lista por los cuatro parametros
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("SELECT * FROM lente WHERE (".$cil." BETWEEN cilindro AND  cilin) AND (calidad = '".$cal."') AND (idcat = ".$cat.") AND (tipo = '".$tipo."') AND probvi_model ='CILINDRO'");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorEsfyCali($es,$cali)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select * from lente where (".$es." BETWEEN `lente`.`mi` AND  `lente`.`mf` and calidad='".$cali."') order by idlente");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCilyCali($cil,$cali)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select * from lente where(".$cil." BETWEEN `lente`.`cilindro` AND  `lente`.`cilin` and calidad='".$cali."') order by idlente");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	
	public function ListarPorCalidad($vl)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select * from lente where(calidad ='".$vl."') order by idlente");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	////////////////////////////////////////
		
	public function BuscarPorCodigo($vcod)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select * from lente where(idlente = '".$vcod."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->idlente=$rs->fields["idlente"];
				$this->idcat=$rs->fields["idcat"];				 
				$this->marca=$rs->fields["marca"];
				$this->tipo=$rs->fields["tipo"];
				$this->probvi_model=$rs->fields["probvi_model"];
				$this->modelo=$rs->fields["modelo"];
				$this->cilindro=$rs->fields["cilindro"];
				$this->cilin=$rs->fields["cilin"];
				$this->diametro=$rs->fields["diametro"];
				$this->altura=$rs->fields["altura"];
				$this->calidad=$rs->fields["calidad"];
				$this->color=$rs->fields["color"];
				$this->mi=$rs->fields["mi"];
				$this->mf=$rs->fields["mf"];
				$this->precio=$rs->fields["precio"];
 				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	///////////////////////////$idlente,$idcat,$marca,$tipo,$probvi_model,$modelo,$cilindro,$cilin,$diametro,$altura,$calidad,$color,$mi,$mf,$precio
	///////////////////////////idlente,idcat,marca,tipo,probvi_model,modelo,cilindro,cilin,diametro,altura,calidad,color,mi,mf,precio
	public function Actualizar($idlente,$idcat,$marca,$tipo,$probvi_model,$model,$cilindro,$cilin,$diametro,$altura,$calidad,$color,$mi,$mf,$precio)			
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("update lente set idcat = ".$idcat.", marca='".$marca."',tipo='".$tipo."', probvi_model ='".$probvi_model."', modelo='".$model."', cilindro=".$cilindro.",cilin=".$cilin.",diametro='".$diametro."', altura='".$altura."', calidad = '".$calidad."', color = '".$color."', mi=".$mi.", mf=".$mf.", precio=".$precio." where (idlente='".$idlente."')"))//si es exitosa la consulta			   
		{
		  $resp=true; 
		}	
		return $resp;
	}
	/////////////////////////////////*/
		
	public function ListaTotal()
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select * from lente order by idcat");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	
	//////////////////////////
	public function ListarPorCodigo($vcod)
	{
		$vector=null;
		$db= new DBManager();		
		$rs=$db->execute("select * from lente where (idlente ='".$vcod."') order by idlente");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                 $vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
        	return $vector;			
		}else return null;
		
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	////////////////////////////
	public function ListaPaginada($vpro,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();			
		$rs=$db->execute("SELECT * FROM lente WHERE (idcat LIKE CONCAT('%','".$vpro."','%')) ORDER BY idlente ASC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("idlente"	=> $rs->fields["idlente"],   			    					
									"idcat"=> $rs->fields["idcat"],
									"marca"=> $rs->fields["marca"],
									"tipo"=> $rs->fields["tipo"],
									"probvi_model"=> $rs->fields["probvi_model"],
									"modelo"=> $rs->fields["modelo"],
									"cilindro"=> $rs->fields["cilindro"],
									"cilin"=> $rs->fields["cilin"],
									"diametro"=> $rs->fields["diametro"],
									"altura"=> $rs->fields["altura"],
									"calidad"=> $rs->fields["calidad"],
									"color"=> $rs->fields["color"],
									"mi"=> $rs->fields["mi"],
									"mf"=> $rs->fields["mf"],
									"precio"=> $rs->fields["precio"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	
	////////////////////////////////////////////////////////////////////////////////////////
public function ActualizarPrecio($idlente,$precio)			
	{
		$resp=false;		
		$db= new DBManager();	
		if($db->_execute("update lente set precio=".$precio." where (idlente='".$idlente."')"))//si es exitosa la consulta			   
		{
		  $resp=true; 
		}	
		return $resp;
	}
	///////////////////////////////////////							
	
	public function getidlente(){ return $this->idlente;}
	public function getidcat(){ return $this->idcat;}
	public function getmarca(){ return $this->marca;}
	public function gettipo(){ return $this->tipo;}
	public function getprobvi_model(){ return $this->probvi_model;}
	public function getmodelo(){ return $this->modelo;}
	public function getcilindro(){ return $this->cilindro;}
	public function getcilin(){ return $this->cilin;}
	public function getdiametro(){ return $this->diametro;}
	public function getaltura(){ return $this->altura;}
	public function getcalidad(){ return $this->calidad;}
	public function getcolor(){ return $this->color;}
	public function getmi(){ return $this->mi;}
	public function getmf(){ return $this->mf;}
	public function getprecio(){ return $this->precio;}
					
}
?>