<?php
/** 
 * Class: Linea.class.php
 * 
 * Esta clase permitir el registro y actualizacin de las lineas 
 * organizacionales de Silicon System SAC						  
 * 
 * @version 	1.0 24/01/2007-Ultima_Modificacion:26/01/2007 
 * @author		Arturo Trigoso. 
 * @copyright	Copyright (c) 2007 Silicon Systems SAC. (http://www.siliconsystems.com)
 */

require_once("DBManager.class.php");

class Documento{
	private $coddoc;
	private $doc;
	
	public function BuscarPorCodigo($vcodmarc)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select * from documento where (coddoc = '".$vcodmarc."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->coddoc=$rs->fields["coddoc"];
   			    $this->doc=$rs->fields["doc"];   			    
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	public function ListarPorCriterio($vnommarc)
	{
		$vector=null;		
		$db= new DBManager();		
		$rs=$db->execute("select * from documento where(doc LIKE CONCAT('%','".$vnommarc."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coddoc"	=> $rs->fields["coddoc"],
   			    					"doc" 	=> $rs->fields["doc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListaPaginada($vpro,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();	
		$rs=$db->execute("SELECT * FROM documento WHERE ( doc LIKE CONCAT('%','".$vpro."','%') ) ORDER BY coddoc ASC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("coddoc"	=> $rs->fields["coddoc"],
   			    					"doc" 	=> $rs->fields["doc"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Crear($cod,$vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("INSERT INTO documento(coddoc,doc) VALUES('".$cod."','".$vnommarc."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}	
	
	public function Actualizar($vcod,$vnommarc)
	{
		$resp=false;		
		$db= new DBManager();		
		if($db->_execute("update  documento set doc = '".$vnommarc."' where (coddoc='".$vcod."')"))   
		{
			$resp=true;
		}
		return $resp;		
	}	

	public function getCoddoc(){ return $this->coddoc;}
	public function getDoc(){ return $this->doc;}	
	
	
}
?>