<?php
require_once("DBManager.class.php");

class Cabingreso{
	private $coding;///
	private $idprov;
	private $fecha_ing;
	private $fechaemi;
	private $fechaven;
	private $serie;
	private $num;
	private $coddoc;
	private $idestado; //viene de la tabla estado : cancelado, sin cancelar, anulado, etc
	private $acuenta;
	private $tipopago; //cheque  o efectivo
	private $codbanco;
	private $nrocuenta;
	private $idmoneda;
	private $tipocambio;
	private $subtotal;
	private $igv;
	private $total;
	
	
	public function Correlativo()
	{
		$vCorre2 = 1;		
		$vCont = 1;
		$vCeros = "";
		$delta_ceros = 0;
		$AnoSiguiente = 0;
		$AnoActual = 0;
		$fecha = getdate();
		
		$db= new DBManager();
		$rs=$db->execute("SELECT coding FROM cabingreso ORDER BY coding;");
		
		//Entra a este bloque si existe algun valor en el campo INroOrd		
		if($rs->lastRow())
		{			
			
		
			$vCorre1 = substr($rs->fields['coding'],0,5);//variable que almacena los 4 primeros caracteres de INroOrd
			$vCorre2 = substr($rs->fields['coding'],6); //extraigo los ultimos 5 caracteres de INroOrd 			
			
			$vCorre1 = intval($vCorre1); //obtengo el valor entero
			$vCorre2 = intval($vCorre2); //obtengo el valor entero
							
			$vCorre2++;//se incrementa en 1, es decir el correlativo
			
			//verifico si el correlativo llega a ocupar los 5 digitos
		 	$delta_ceros = 6 - strlen($vCorre2);
			
			if( $delta_ceros == 0 )// Si en el codigo  correlativo ya no existen ceros que poner es decir vCorre2 = 10000
			{
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{

						return ($vCorre1.$vCorre2);
					}			
			}
			
			if( $delta_ceros < 0 /*-1*/)// Si en el codigo correlativo ya no existen ceros que poner y ya llego al limite, en este caso delta_ceros = -1
			{
				$AnoSiguiente = $vCorre1+=1;
				return $AnoSiguiente."0000001";
			}
			
			if( $delta_ceros > 0) // Si en el codigo correlativo existen ceros que poner
			{
			
				//Si es que he pasado al siguiente ao
				$AnoActual = intval($fecha['year']);
				if($AnoActual>$vCorre1)
				{   
					$AnoSiguiente = $vCorre1+=1;
					return $AnoSiguiente."0000001";
				}
				else{
						for($i=1; $i<$delta_ceros; $i++)
						{
							$vCont++;//contador de ceros
						}			
						$vCeros=str_pad($vCeros,$vCont,'0',STR_PAD_RIGHT);//rellenar de ceros al lado derecho		
						return($vCorre1.$vCeros.$vCorre2);
					}			
			}			

		}else{ 
				//Caso contrario esta vacio el campo al inicio de las acciones				
				return ($fecha['year']."000000".$vCorre2);				
			 }

		$rs->close();
		$db->closeConnection();//opcional			
	}
							//$cod,$idprov,$fecha_ing,$fechaemi,$fechaven,$serie,$num,$coddoc,$idestado,$acuenta,$tipopago,$codbanco,$nrocuenta,$idmoneda,$tipocambio,$idusuemp,$subtotal,$igv,$total
	public function Crear($vcoding,$vidprov,$vfecha_ing,$vfechaemi,$vfechaven,$vserie,$vnum,$vcoddoc,$videstado,$vacuenta,$vtipopago,$vcodbanco,$vnrocuenta,$vidmoneda,$vtipocambio,$vidusuemp,$vsubtotal,$vigv,$vtotal)
	{
		$resp=false;		
		$db= new DBManager();
		$hora = getdate(); //tomo la fecha actual con todo hora
		$vhora = $hora['hours'].":".$hora['minutes'].":".$hora['seconds'];
		$vfecha_ing = implode("-", array_reverse(explode("-", $vfecha_ing)));	
		$vfeching	= $vfecha_ing." ".$vhora;
		$vfechaemi = implode("-", array_reverse(explode("-", $vfechaemi)));	
		$vfechaven = implode("-", array_reverse(explode("-", $vfechaven)));	
		if($db->_execute("INSERT INTO cabingreso(coding,idprov,fecha_ing,fechaemi,fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total) VALUES('".$vcoding."',".$vidprov.",'".$vfeching."','".$vfechaemi."','".$vfechaven."','".$vserie."','".$vnum."','".$vcoddoc."',".$videstado.",".$vacuenta.",'".$vtipopago."',".$vcodbanco.",'".$vnrocuenta."',".$vidmoneda.",".$vtipocambio.",".$vidusuemp.",".$vsubtotal.",".$vigv.",".$vtotal.")"))   
		{
			$resp=true;
		}
		return $resp;		
	}
	
	public function ListarPorProveedor($vclt)
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where(idprov = ".$vclt.")");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorPagarProveedor($vclt)
	{
		$vector=null;		
		$db= new DBManager('opticaco_marlene','colmena2013');
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where(idprov = ".$vclt." and idestado='2')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////////
	public function ListarPorCriterio()
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso order by coding desc");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	//////////////////////////7777777777
	
	public function ListarPorFecha($vfecha_ing)
	{
	$vector=null;		
		$db= new DBManager('opticaco_marlene','colmena2013');
		$vfecha_ing = implode("-", array_reverse(explode("-", $vfecha_ing)));
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where(fecha_ing LIKE CONCAT('%','".$vfecha_ing."','%'))");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();
	
	}
	////////////////////////////////esto para paginar//////////////
	public function ListarPorNumIngreso($vid)
	{
		$vector=null;		
		$db= new DBManager('opticaco_marlene','colmena2013');
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where(num ='".$vid."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	/////////////////////////////////////////////////////////////////////////
	public function ListarPorDocumento($vid)// para reportes
	{
		$vector=null;		
		$db= new DBManager('opticaco_marlene','colmena2013');
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where ( coddoc LIKE CONCAT('%','".$vid."','%')) ORDER BY coding DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////para el reporte////////////////////////////////////
	public function ListarPorEstado($x) // para reportes
	{
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where idestado=".$x." ORDER BY coding DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function ListarPorCancelar() // para reportes
	{
		$vector=null;		
		$db= new DBManager('opticaco_marlene','colmena2013');
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where idestado='2' ORDER BY coding DESC;");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	///////////////////////////////////////////////////
	public function ListaPaginadaEstado($x,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where ( estadopago='".$x."') ORDER BY coding DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	/////////////////////////////////////////////////
	public function ListaPaginada($vid,$limitInf,$tampag)
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where ( coding LIKE CONCAT('%','".$vid."','%') ) ORDER BY coding DESC limit ".$limitInf.",".$tampag.";");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}
	
	public function Filtrar($fechai,$fechaf)//  pra reportes
	{    /////////////////////////////////////
		$vector=null;		
		$db= new DBManager();
		$fechai = implode("-", array_reverse(explode("-", $fechai)));
		$fechaf = implode("-", array_reverse(explode("-", $fechaf)));		
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where fecha_ing BETWEEN '".$fechai."' AND '".$fechaf."'");			
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$row=0;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) 
			{    
   				$vector[$row]=array("coding"	=> $rs->fields["coding"],
									"idprov" 	=> $rs->fields["idprov"],
   			    					"fecha_ing" 	=> $rs->fields["fecha_ing"],
									"fechaemi" 	=> $rs->fields["fechaemi"],
									"fechaven" 	=> $rs->fields["fechaven"],
									"serie" 	=> $rs->fields["serie"],
									"num" 	=> $rs->fields["num"],
									"coddoc" 	=> $rs->fields["coddoc"],
									"idestado" 	=> $rs->fields["idestado"],
									"acuenta" 	=> $rs->fields["acuenta"],
									"tipopago" 	=> $rs->fields["tipopago"],
									"codbanco" 	=> $rs->fields["codbanco"],
									"nrocuenta" 	=> $rs->fields["nrocuenta"],
									"idmoneda" 	=> $rs->fields["idmoneda"],
									"tipocambio" 	=> $rs->fields["tipocambio"],
									"idusuemp" 	=> $rs->fields["idusuemp"],
									"subtotal" 	=> $rs->fields["subtotal"],
									"igv" 	=> $rs->fields["igv"],
									"total" 	=> $rs->fields["total"]);
                $row++;
				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
         	}			
        	return $vector;			
		}else return null;
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              						
	}	
		
	public function BuscarPorCodigo($vcod)
	{
		
		$resp=false;
		$num_rows=0;//numero de filas afectada por la consulta
		$db= new DBManager();
		$rs=$db->execute("select coding,idprov,DATE_FORMAT(fecha_ing,'%d-%m-%Y, %h:%i:%s') AS fecha_ing,DATE_FORMAT(fechaemi,'%d-%m-%Y') AS fechaemi,DATE_FORMAT(fechaven,'%d-%m-%Y') AS fechaven,serie,num,coddoc,idestado,acuenta,tipopago,codbanco,nrocuenta,idmoneda,tipocambio,idusuemp,subtotal,igv,total from cabingreso where(coding = '".$vcod."')");
		$num_rows=$rs->getNumOfRows();
		if($num_rows>0)
		{	$resp=true;
			$rs->firstRow(); // opcional, pero recomendado
			while (!$rs->EOF) {
                // Coleccion de campos accesible mediante arrays asociativos tambin
                $this->coding=$rs->fields["coding"];
				$this->idprov=$rs->fields["idprov"];
				$this->fecha_ing=$rs->fields["fecha_ing"];
				$this->fechaemi=$rs->fields["fechaemi"];
				$this->fechaven=$rs->fields["fechaven"];
				$this->serie=$rs->fields["serie"];
				$this->num=$rs->fields["num"];
				$this->coddoc=$rs->fields["coddoc"];
				$this->idestado=$rs->fields["idestado"];
				$this->acuenta=$rs->fields["acuenta"];
				$this->tipopago=$rs->fields["tipopago"];
				$this->codbanco=$rs->fields["codbanco"];
				$this->nrocuenta=$rs->fields["nrocuenta"];
				$this->idmoneda=$rs->fields["idmoneda"];
				$this->tipocambio=$rs->fields["tipocambio"];
				$this->idusuemp=$rs->fields["idusuemp"];
				$this->subtotal=$rs->fields["subtotal"];
				$this->igv=$rs->fields["igv"];
				$this->total=$rs->fields["total"];
 				$rs->nextRow(); // Nota: nextRow() Esta situado al final				
        	}			
		}
		$rs->close(); 
		$db->closeConnection();//opcional cierra el enlace de la Base de Datos              
		return $resp;							
	}
	
	
	public function ActualizarMonto($vcod,$vtotal,$vsubtotal)
	{
		$resp=false;		
		$db= new DBManager();	
		if($db->_execute("UPDATE cabingreso SET subtotal = ".$vsubtotal.", total=".$vtotal." WHERE (coding = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	//////////////////////////////
	public function ActualizarEstadosT($vcod,$vestadopago)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("UPDATE cabingreso SET idestado = ".$vestadopago." WHERE (coding = '".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;	
	
	}
	
	/*/////////////////////////////
	public function Eliminar($vcod)
	{
		$resp=false;		
		$db= new DBManager();
		if($db->_execute("DELETE FROM pedido WHERE (idpedido='".$vcod."');"))   
		{
			$resp=true;
		}
		return $resp;		
	}	*/							
	
	public function getCoding(){ return $this->coding;}
	public function getIdprov(){ return $this->idprov;}
	public function getFecha_ing(){ return $this->fecha_ing;}
	public function getFechaemi(){ return $this->fechaemi;}
	public function getFechaven(){ return $this->fechaven;}
	public function getSerie(){ return $this->serie;}
	public function getNum(){ return $this->num;}
	public function getCoddoc(){ return $this->coddoc;}
	public function getIdestado(){ return $this->idestado;}
	public function getAcuenta(){ return $this->acuenta;}
	public function getTipopago(){ return $this->tipopago;}
	public function getCodbanco(){ return $this->codbanco;}
	public function getNrocuenta(){ return $this->nrocuenta;}
	public function getIdmoneda(){ return $this->idmoneda;}
	public function getTipocambio(){ return $this->tipocambio;}
	public function getIdusuemp(){ return $this->idusuemp;}
	public function getSubtotal(){ return $this->subtotal;}
	public function getIgv(){ return $this->igv;}
	public function getTotal(){ return $this->total;}
}
?>