<?php
session_start(); // Iniciar la sesión

// Mapeo de números a días de la semana
$dias_semana = [
    1 => "Domingo",
    2 => "Lunes",
    3 => "Martes",
    4 => "Miércoles",
    5 => "Jueves",
    6 => "Viernes",
    7 => "Sábado"
];

// Inicializar el arreglo si no existe
if (!isset($_SESSION['numeros_dias'])) {
    $_SESSION['numeros_dias'] = [];
}

// Verificar si se ha enviado un nuevo número
if (isset($_POST['numero'])) {
    $numero = $_POST['numero'];

    // Verificar si el número está entre 1 y 7
    if (is_numeric($numero) && $numero >= 1 && $numero <= 7) {
        // Agregar el número y el día correspondiente al arreglo
        $_SESSION['numeros_dias'][] = [
            'numero' => $numero,
            'dia' => $dias_semana[$numero]
        ];
    } else {
        echo "Por favor, ingresa un número válido (1 a 7).";
    }
}

// Verificar si se ha enviado una solicitud para eliminar un número
if (isset($_POST['numero_eliminar'])) {
    $numero_eliminar = $_POST['numero_eliminar'];

    // Buscar el número en el arreglo y eliminarlo
    foreach ($_SESSION['numeros_dias'] as $indice => $entrada) {
        if ($entrada['numero'] == $numero_eliminar) {
            unset($_SESSION['numeros_dias'][$indice]); // Eliminar el número
            $_SESSION['numeros_dias'] = array_values($_SESSION['numeros_dias']); // Reindexar el arreglo
            break; // Salir del bucle después de eliminar
        }
    }
}

// Mostrar el arreglo de números y días
echo "<h3>Números y días almacenados:</h3>";
echo "<ul>";
foreach ($_SESSION['numeros_dias'] as $entry) {
    echo "<li>Número: {$entry['numero']} - Día: {$entry['dia']}</li>";
}
echo "</ul>";
?>

<!-- Formulario para ingresar el número -->
<form method="post" action="">
    <label for="numero">Ingresa un número (1-7):</label>
    <input type="text" name="numero" id="numero" required>
    <button type="submit">Agregar</button>
</form>

<!-- Formulario para eliminar un número -->
<form method="post" action="">
    <label for="numero_eliminar">Ingresa el número que deseas eliminar:</label>
    <input type="text" name="numero_eliminar" id="numero_eliminar" required>
    <button type="submit">Eliminar</button>
</form>

<!-- Botón para reiniciar el arreglo -->
<form method="post" action="">
    <button type="submit" name="reiniciar">Reiniciar arreglo</button>
</form>

<?php
// Reiniciar el arreglo
if (isset($_POST['reiniciar'])) {
    $_SESSION['numeros_dias'] = [];
    header("Location: arreglo.php"); // Recargar la página
    exit();
}
?>